package zio.aws.paymentcryptographydata.model
import zio.aws.paymentcryptographydata.model.primitives.{
  HexLengthEquals1,
  NumberLengthBetween4And16,
  NumberLengthBetween4And12,
  NumberLengthEquals16
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class Ibm3624PinVerification(
    decimalizationTable: NumberLengthEquals16,
    pinOffset: NumberLengthBetween4And12,
    pinValidationData: NumberLengthBetween4And16,
    pinValidationDataPadCharacter: HexLengthEquals1
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.Ibm3624PinVerification = {
    import Ibm3624PinVerification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.Ibm3624PinVerification
      .builder()
      .decimalizationTable(
        NumberLengthEquals16.unwrap(decimalizationTable): java.lang.String
      )
      .pinOffset(NumberLengthBetween4And12.unwrap(pinOffset): java.lang.String)
      .pinValidationData(
        NumberLengthBetween4And16.unwrap(pinValidationData): java.lang.String
      )
      .pinValidationDataPadCharacter(
        HexLengthEquals1.unwrap(pinValidationDataPadCharacter): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptographydata.model.Ibm3624PinVerification.ReadOnly =
    zio.aws.paymentcryptographydata.model.Ibm3624PinVerification
      .wrap(buildAwsValue())
}
object Ibm3624PinVerification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.Ibm3624PinVerification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.paymentcryptographydata.model.Ibm3624PinVerification =
      zio.aws.paymentcryptographydata.model.Ibm3624PinVerification(
        decimalizationTable,
        pinOffset,
        pinValidationData,
        pinValidationDataPadCharacter
      )
    def decimalizationTable: NumberLengthEquals16
    def pinOffset: NumberLengthBetween4And12
    def pinValidationData: NumberLengthBetween4And16
    def pinValidationDataPadCharacter: HexLengthEquals1
    def getDecimalizationTable: ZIO[Any, Nothing, NumberLengthEquals16] =
      ZIO.succeed(decimalizationTable)
    def getPinOffset: ZIO[Any, Nothing, NumberLengthBetween4And12] =
      ZIO.succeed(pinOffset)
    def getPinValidationData: ZIO[Any, Nothing, NumberLengthBetween4And16] =
      ZIO.succeed(pinValidationData)
    def getPinValidationDataPadCharacter: ZIO[Any, Nothing, HexLengthEquals1] =
      ZIO.succeed(pinValidationDataPadCharacter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.Ibm3624PinVerification
  ) extends zio.aws.paymentcryptographydata.model.Ibm3624PinVerification.ReadOnly {
    override val decimalizationTable: NumberLengthEquals16 =
      zio.aws.paymentcryptographydata.model.primitives
        .NumberLengthEquals16(impl.decimalizationTable())
    override val pinOffset: NumberLengthBetween4And12 =
      zio.aws.paymentcryptographydata.model.primitives
        .NumberLengthBetween4And12(impl.pinOffset())
    override val pinValidationData: NumberLengthBetween4And16 =
      zio.aws.paymentcryptographydata.model.primitives
        .NumberLengthBetween4And16(impl.pinValidationData())
    override val pinValidationDataPadCharacter: HexLengthEquals1 =
      zio.aws.paymentcryptographydata.model.primitives
        .HexLengthEquals1(impl.pinValidationDataPadCharacter())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.Ibm3624PinVerification
  ): zio.aws.paymentcryptographydata.model.Ibm3624PinVerification.ReadOnly =
    new Wrapper(impl)
}
