package zio.aws.paymentcryptographydata.model
import zio.aws.paymentcryptographydata.model.primitives.{
  HexLengthEquals1,
  NumberLengthBetween4And16,
  HexLengthBetween16And32,
  NumberLengthEquals16
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class Ibm3624PinOffset(
    decimalizationTable: NumberLengthEquals16,
    encryptedPinBlock: HexLengthBetween16And32,
    pinValidationData: NumberLengthBetween4And16,
    pinValidationDataPadCharacter: HexLengthEquals1
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.Ibm3624PinOffset = {
    import Ibm3624PinOffset.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.Ibm3624PinOffset
      .builder()
      .decimalizationTable(
        NumberLengthEquals16.unwrap(decimalizationTable): java.lang.String
      )
      .encryptedPinBlock(
        HexLengthBetween16And32.unwrap(encryptedPinBlock): java.lang.String
      )
      .pinValidationData(
        NumberLengthBetween4And16.unwrap(pinValidationData): java.lang.String
      )
      .pinValidationDataPadCharacter(
        HexLengthEquals1.unwrap(pinValidationDataPadCharacter): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptographydata.model.Ibm3624PinOffset.ReadOnly =
    zio.aws.paymentcryptographydata.model.Ibm3624PinOffset.wrap(buildAwsValue())
}
object Ibm3624PinOffset {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.Ibm3624PinOffset
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptographydata.model.Ibm3624PinOffset =
      zio.aws.paymentcryptographydata.model.Ibm3624PinOffset(
        decimalizationTable,
        encryptedPinBlock,
        pinValidationData,
        pinValidationDataPadCharacter
      )
    def decimalizationTable: NumberLengthEquals16
    def encryptedPinBlock: HexLengthBetween16And32
    def pinValidationData: NumberLengthBetween4And16
    def pinValidationDataPadCharacter: HexLengthEquals1
    def getDecimalizationTable: ZIO[Any, Nothing, NumberLengthEquals16] =
      ZIO.succeed(decimalizationTable)
    def getEncryptedPinBlock: ZIO[Any, Nothing, HexLengthBetween16And32] =
      ZIO.succeed(encryptedPinBlock)
    def getPinValidationData: ZIO[Any, Nothing, NumberLengthBetween4And16] =
      ZIO.succeed(pinValidationData)
    def getPinValidationDataPadCharacter: ZIO[Any, Nothing, HexLengthEquals1] =
      ZIO.succeed(pinValidationDataPadCharacter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.Ibm3624PinOffset
  ) extends zio.aws.paymentcryptographydata.model.Ibm3624PinOffset.ReadOnly {
    override val decimalizationTable: NumberLengthEquals16 =
      zio.aws.paymentcryptographydata.model.primitives
        .NumberLengthEquals16(impl.decimalizationTable())
    override val encryptedPinBlock: HexLengthBetween16And32 =
      zio.aws.paymentcryptographydata.model.primitives
        .HexLengthBetween16And32(impl.encryptedPinBlock())
    override val pinValidationData: NumberLengthBetween4And16 =
      zio.aws.paymentcryptographydata.model.primitives
        .NumberLengthBetween4And16(impl.pinValidationData())
    override val pinValidationDataPadCharacter: HexLengthEquals1 =
      zio.aws.paymentcryptographydata.model.primitives
        .HexLengthEquals1(impl.pinValidationDataPadCharacter())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.Ibm3624PinOffset
  ): zio.aws.paymentcryptographydata.model.Ibm3624PinOffset.ReadOnly =
    new Wrapper(impl)
}
