package zio.aws.paymentcryptographydata.model
import zio.aws.paymentcryptographydata.model.primitives.{
  HexLengthEquals1,
  NumberLengthBetween4And16,
  NumberLengthEquals16
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class Ibm3624NaturalPin(
    decimalizationTable: NumberLengthEquals16,
    pinValidationData: NumberLengthBetween4And16,
    pinValidationDataPadCharacter: HexLengthEquals1
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.Ibm3624NaturalPin = {
    import Ibm3624NaturalPin.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.Ibm3624NaturalPin
      .builder()
      .decimalizationTable(
        NumberLengthEquals16.unwrap(decimalizationTable): java.lang.String
      )
      .pinValidationData(
        NumberLengthBetween4And16.unwrap(pinValidationData): java.lang.String
      )
      .pinValidationDataPadCharacter(
        HexLengthEquals1.unwrap(pinValidationDataPadCharacter): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptographydata.model.Ibm3624NaturalPin.ReadOnly =
    zio.aws.paymentcryptographydata.model.Ibm3624NaturalPin
      .wrap(buildAwsValue())
}
object Ibm3624NaturalPin {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.Ibm3624NaturalPin
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptographydata.model.Ibm3624NaturalPin =
      zio.aws.paymentcryptographydata.model.Ibm3624NaturalPin(
        decimalizationTable,
        pinValidationData,
        pinValidationDataPadCharacter
      )
    def decimalizationTable: NumberLengthEquals16
    def pinValidationData: NumberLengthBetween4And16
    def pinValidationDataPadCharacter: HexLengthEquals1
    def getDecimalizationTable: ZIO[Any, Nothing, NumberLengthEquals16] =
      ZIO.succeed(decimalizationTable)
    def getPinValidationData: ZIO[Any, Nothing, NumberLengthBetween4And16] =
      ZIO.succeed(pinValidationData)
    def getPinValidationDataPadCharacter: ZIO[Any, Nothing, HexLengthEquals1] =
      ZIO.succeed(pinValidationDataPadCharacter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.Ibm3624NaturalPin
  ) extends zio.aws.paymentcryptographydata.model.Ibm3624NaturalPin.ReadOnly {
    override val decimalizationTable: NumberLengthEquals16 =
      zio.aws.paymentcryptographydata.model.primitives
        .NumberLengthEquals16(impl.decimalizationTable())
    override val pinValidationData: NumberLengthBetween4And16 =
      zio.aws.paymentcryptographydata.model.primitives
        .NumberLengthBetween4And16(impl.pinValidationData())
    override val pinValidationDataPadCharacter: HexLengthEquals1 =
      zio.aws.paymentcryptographydata.model.primitives
        .HexLengthEquals1(impl.pinValidationDataPadCharacter())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.Ibm3624NaturalPin
  ): zio.aws.paymentcryptographydata.model.Ibm3624NaturalPin.ReadOnly =
    new Wrapper(impl)
}
