package zio.aws.paymentcryptographydata.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.paymentcryptographydata.model.primitives.{
  IntegerRangeBetween3And5Type,
  NumberLengthBetween12And19,
  KeyArnOrKeyAliasType
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GenerateCardValidationDataRequest(
    generationAttributes: zio.aws.paymentcryptographydata.model.CardGenerationAttributes,
    keyIdentifier: KeyArnOrKeyAliasType,
    primaryAccountNumber: NumberLengthBetween12And19,
    validationDataLength: Optional[IntegerRangeBetween3And5Type] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.GenerateCardValidationDataRequest = {
    import GenerateCardValidationDataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.GenerateCardValidationDataRequest
      .builder()
      .generationAttributes(generationAttributes.buildAwsValue())
      .keyIdentifier(
        KeyArnOrKeyAliasType.unwrap(keyIdentifier): java.lang.String
      )
      .primaryAccountNumber(
        NumberLengthBetween12And19.unwrap(
          primaryAccountNumber
        ): java.lang.String
      )
      .optionallyWith(
        validationDataLength.map(value =>
          IntegerRangeBetween3And5Type.unwrap(value): Integer
        )
      )(_.validationDataLength)
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptographydata.model.GenerateCardValidationDataRequest.ReadOnly =
    zio.aws.paymentcryptographydata.model.GenerateCardValidationDataRequest
      .wrap(buildAwsValue())
}
object GenerateCardValidationDataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.GenerateCardValidationDataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.paymentcryptographydata.model.GenerateCardValidationDataRequest =
      zio.aws.paymentcryptographydata.model.GenerateCardValidationDataRequest(
        generationAttributes.asEditable,
        keyIdentifier,
        primaryAccountNumber,
        validationDataLength.map(value => value)
      )
    def generationAttributes
        : zio.aws.paymentcryptographydata.model.CardGenerationAttributes.ReadOnly
    def keyIdentifier: KeyArnOrKeyAliasType
    def primaryAccountNumber: NumberLengthBetween12And19
    def validationDataLength: Optional[IntegerRangeBetween3And5Type]
    def getGenerationAttributes: ZIO[
      Any,
      Nothing,
      zio.aws.paymentcryptographydata.model.CardGenerationAttributes.ReadOnly
    ] = ZIO.succeed(generationAttributes)
    def getKeyIdentifier: ZIO[Any, Nothing, KeyArnOrKeyAliasType] =
      ZIO.succeed(keyIdentifier)
    def getPrimaryAccountNumber: ZIO[Any, Nothing, NumberLengthBetween12And19] =
      ZIO.succeed(primaryAccountNumber)
    def getValidationDataLength
        : ZIO[Any, AwsError, IntegerRangeBetween3And5Type] =
      AwsError.unwrapOptionField("validationDataLength", validationDataLength)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.GenerateCardValidationDataRequest
  ) extends zio.aws.paymentcryptographydata.model.GenerateCardValidationDataRequest.ReadOnly {
    override val generationAttributes
        : zio.aws.paymentcryptographydata.model.CardGenerationAttributes.ReadOnly =
      zio.aws.paymentcryptographydata.model.CardGenerationAttributes
        .wrap(impl.generationAttributes())
    override val keyIdentifier: KeyArnOrKeyAliasType =
      zio.aws.paymentcryptographydata.model.primitives
        .KeyArnOrKeyAliasType(impl.keyIdentifier())
    override val primaryAccountNumber: NumberLengthBetween12And19 =
      zio.aws.paymentcryptographydata.model.primitives
        .NumberLengthBetween12And19(impl.primaryAccountNumber())
    override val validationDataLength: Optional[IntegerRangeBetween3And5Type] =
      zio.aws.core.internal
        .optionalFromNullable(impl.validationDataLength())
        .map(value =>
          zio.aws.paymentcryptographydata.model.primitives
            .IntegerRangeBetween3And5Type(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.GenerateCardValidationDataRequest
  ): zio.aws.paymentcryptographydata.model.GenerateCardValidationDataRequest.ReadOnly =
    new Wrapper(impl)
}
