package zio.aws.paymentcryptographydata.model
import scala.jdk.CollectionConverters.*
sealed trait EncryptionMode {
  def unwrap: software.amazon.awssdk.services.paymentcryptographydata.model.EncryptionMode
}
object EncryptionMode {
  def wrap(
      value: software.amazon.awssdk.services.paymentcryptographydata.model.EncryptionMode
  ): zio.aws.paymentcryptographydata.model.EncryptionMode = value match {
    case software.amazon.awssdk.services.paymentcryptographydata.model.EncryptionMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.paymentcryptographydata.model.EncryptionMode.ECB =>
      val r = ECB
      r
    case software.amazon.awssdk.services.paymentcryptographydata.model.EncryptionMode.CBC =>
      val r = CBC
      r
    case software.amazon.awssdk.services.paymentcryptographydata.model.EncryptionMode.CFB =>
      val r = CFB
      r
    case software.amazon.awssdk.services.paymentcryptographydata.model.EncryptionMode.CFB1 =>
      val r = CFB1
      r
    case software.amazon.awssdk.services.paymentcryptographydata.model.EncryptionMode.CFB8 =>
      val r = CFB8
      r
    case software.amazon.awssdk.services.paymentcryptographydata.model.EncryptionMode.CFB64 =>
      val r = CFB64
      r
    case software.amazon.awssdk.services.paymentcryptographydata.model.EncryptionMode.CFB128 =>
      val r = CFB128
      r
    case software.amazon.awssdk.services.paymentcryptographydata.model.EncryptionMode.OFB =>
      val r = OFB
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.paymentcryptographydata.model.EncryptionMode {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptographydata.model.EncryptionMode =
      software.amazon.awssdk.services.paymentcryptographydata.model.EncryptionMode.UNKNOWN_TO_SDK_VERSION
  }
  case object ECB extends zio.aws.paymentcryptographydata.model.EncryptionMode {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptographydata.model.EncryptionMode =
      software.amazon.awssdk.services.paymentcryptographydata.model.EncryptionMode.ECB
  }
  case object CBC extends zio.aws.paymentcryptographydata.model.EncryptionMode {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptographydata.model.EncryptionMode =
      software.amazon.awssdk.services.paymentcryptographydata.model.EncryptionMode.CBC
  }
  case object CFB extends zio.aws.paymentcryptographydata.model.EncryptionMode {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptographydata.model.EncryptionMode =
      software.amazon.awssdk.services.paymentcryptographydata.model.EncryptionMode.CFB
  }
  case object CFB1
      extends zio.aws.paymentcryptographydata.model.EncryptionMode {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptographydata.model.EncryptionMode =
      software.amazon.awssdk.services.paymentcryptographydata.model.EncryptionMode.CFB1
  }
  case object CFB8
      extends zio.aws.paymentcryptographydata.model.EncryptionMode {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptographydata.model.EncryptionMode =
      software.amazon.awssdk.services.paymentcryptographydata.model.EncryptionMode.CFB8
  }
  case object CFB64
      extends zio.aws.paymentcryptographydata.model.EncryptionMode {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptographydata.model.EncryptionMode =
      software.amazon.awssdk.services.paymentcryptographydata.model.EncryptionMode.CFB64
  }
  case object CFB128
      extends zio.aws.paymentcryptographydata.model.EncryptionMode {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptographydata.model.EncryptionMode =
      software.amazon.awssdk.services.paymentcryptographydata.model.EncryptionMode.CFB128
  }
  case object OFB extends zio.aws.paymentcryptographydata.model.EncryptionMode {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptographydata.model.EncryptionMode =
      software.amazon.awssdk.services.paymentcryptographydata.model.EncryptionMode.OFB
  }
}
