package zio.aws.paymentcryptographydata.model
import zio.aws.paymentcryptographydata.model.primitives.{
  KeyCheckValue,
  KeyArn,
  HexEvenLengthBetween16And4096
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EncryptDataResponse(
    cipherText: HexEvenLengthBetween16And4096,
    keyArn: KeyArn,
    keyCheckValue: Optional[KeyCheckValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.EncryptDataResponse = {
    import EncryptDataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.EncryptDataResponse
      .builder()
      .cipherText(
        HexEvenLengthBetween16And4096.unwrap(cipherText): java.lang.String
      )
      .keyArn(KeyArn.unwrap(keyArn): java.lang.String)
      .optionallyWith(
        keyCheckValue.map(value =>
          KeyCheckValue.unwrap(value): java.lang.String
        )
      )(_.keyCheckValue)
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptographydata.model.EncryptDataResponse.ReadOnly =
    zio.aws.paymentcryptographydata.model.EncryptDataResponse
      .wrap(buildAwsValue())
}
object EncryptDataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.EncryptDataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptographydata.model.EncryptDataResponse =
      zio.aws.paymentcryptographydata.model.EncryptDataResponse(
        cipherText,
        keyArn,
        keyCheckValue.map(value => value)
      )
    def cipherText: HexEvenLengthBetween16And4096
    def keyArn: KeyArn
    def keyCheckValue: Optional[KeyCheckValue]
    def getCipherText: ZIO[Any, Nothing, HexEvenLengthBetween16And4096] =
      ZIO.succeed(cipherText)
    def getKeyArn: ZIO[Any, Nothing, KeyArn] = ZIO.succeed(keyArn)
    def getKeyCheckValue: ZIO[Any, AwsError, KeyCheckValue] =
      AwsError.unwrapOptionField("keyCheckValue", keyCheckValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.EncryptDataResponse
  ) extends zio.aws.paymentcryptographydata.model.EncryptDataResponse.ReadOnly {
    override val cipherText: HexEvenLengthBetween16And4096 =
      zio.aws.paymentcryptographydata.model.primitives
        .HexEvenLengthBetween16And4096(impl.cipherText())
    override val keyArn: KeyArn =
      zio.aws.paymentcryptographydata.model.primitives.KeyArn(impl.keyArn())
    override val keyCheckValue: Optional[KeyCheckValue] = zio.aws.core.internal
      .optionalFromNullable(impl.keyCheckValue())
      .map(value =>
        zio.aws.paymentcryptographydata.model.primitives.KeyCheckValue(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.EncryptDataResponse
  ): zio.aws.paymentcryptographydata.model.EncryptDataResponse.ReadOnly =
    new Wrapper(impl)
}
