package zio.aws.paymentcryptographydata.model
import zio.aws.paymentcryptographydata.model.primitives.{
  HexEvenLengthBetween16And4064,
  KeyArnOrKeyAliasType
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class EncryptDataRequest(
    encryptionAttributes: zio.aws.paymentcryptographydata.model.EncryptionDecryptionAttributes,
    keyIdentifier: KeyArnOrKeyAliasType,
    plainText: HexEvenLengthBetween16And4064
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.EncryptDataRequest = {
    import EncryptDataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.EncryptDataRequest
      .builder()
      .encryptionAttributes(encryptionAttributes.buildAwsValue())
      .keyIdentifier(
        KeyArnOrKeyAliasType.unwrap(keyIdentifier): java.lang.String
      )
      .plainText(
        HexEvenLengthBetween16And4064.unwrap(plainText): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptographydata.model.EncryptDataRequest.ReadOnly =
    zio.aws.paymentcryptographydata.model.EncryptDataRequest
      .wrap(buildAwsValue())
}
object EncryptDataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.EncryptDataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptographydata.model.EncryptDataRequest =
      zio.aws.paymentcryptographydata.model.EncryptDataRequest(
        encryptionAttributes.asEditable,
        keyIdentifier,
        plainText
      )
    def encryptionAttributes
        : zio.aws.paymentcryptographydata.model.EncryptionDecryptionAttributes.ReadOnly
    def keyIdentifier: KeyArnOrKeyAliasType
    def plainText: HexEvenLengthBetween16And4064
    def getEncryptionAttributes: ZIO[
      Any,
      Nothing,
      zio.aws.paymentcryptographydata.model.EncryptionDecryptionAttributes.ReadOnly
    ] = ZIO.succeed(encryptionAttributes)
    def getKeyIdentifier: ZIO[Any, Nothing, KeyArnOrKeyAliasType] =
      ZIO.succeed(keyIdentifier)
    def getPlainText: ZIO[Any, Nothing, HexEvenLengthBetween16And4064] =
      ZIO.succeed(plainText)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.EncryptDataRequest
  ) extends zio.aws.paymentcryptographydata.model.EncryptDataRequest.ReadOnly {
    override val encryptionAttributes
        : zio.aws.paymentcryptographydata.model.EncryptionDecryptionAttributes.ReadOnly =
      zio.aws.paymentcryptographydata.model.EncryptionDecryptionAttributes
        .wrap(impl.encryptionAttributes())
    override val keyIdentifier: KeyArnOrKeyAliasType =
      zio.aws.paymentcryptographydata.model.primitives
        .KeyArnOrKeyAliasType(impl.keyIdentifier())
    override val plainText: HexEvenLengthBetween16And4064 =
      zio.aws.paymentcryptographydata.model.primitives
        .HexEvenLengthBetween16And4064(impl.plainText())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.EncryptDataRequest
  ): zio.aws.paymentcryptographydata.model.EncryptDataRequest.ReadOnly =
    new Wrapper(impl)
}
