package zio.aws.paymentcryptographydata.model
import scala.jdk.CollectionConverters.*
sealed trait DukptKeyVariant {
  def unwrap: software.amazon.awssdk.services.paymentcryptographydata.model.DukptKeyVariant
}
object DukptKeyVariant {
  def wrap(
      value: software.amazon.awssdk.services.paymentcryptographydata.model.DukptKeyVariant
  ): zio.aws.paymentcryptographydata.model.DukptKeyVariant = value match {
    case software.amazon.awssdk.services.paymentcryptographydata.model.DukptKeyVariant.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.paymentcryptographydata.model.DukptKeyVariant.BIDIRECTIONAL =>
      val r = BIDIRECTIONAL
      r
    case software.amazon.awssdk.services.paymentcryptographydata.model.DukptKeyVariant.REQUEST =>
      val r = REQUEST
      r
    case software.amazon.awssdk.services.paymentcryptographydata.model.DukptKeyVariant.RESPONSE =>
      val r = RESPONSE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.paymentcryptographydata.model.DukptKeyVariant {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptographydata.model.DukptKeyVariant =
      software.amazon.awssdk.services.paymentcryptographydata.model.DukptKeyVariant.UNKNOWN_TO_SDK_VERSION
  }
  case object BIDIRECTIONAL
      extends zio.aws.paymentcryptographydata.model.DukptKeyVariant {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptographydata.model.DukptKeyVariant =
      software.amazon.awssdk.services.paymentcryptographydata.model.DukptKeyVariant.BIDIRECTIONAL
  }
  case object REQUEST
      extends zio.aws.paymentcryptographydata.model.DukptKeyVariant {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptographydata.model.DukptKeyVariant =
      software.amazon.awssdk.services.paymentcryptographydata.model.DukptKeyVariant.REQUEST
  }
  case object RESPONSE
      extends zio.aws.paymentcryptographydata.model.DukptKeyVariant {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptographydata.model.DukptKeyVariant =
      software.amazon.awssdk.services.paymentcryptographydata.model.DukptKeyVariant.RESPONSE
  }
}
