package zio.aws.paymentcryptographydata.model
import zio.aws.paymentcryptographydata.model.primitives.{
  HexLengthBetween10And24,
  HexLength16Or32
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DukptEncryptionAttributes(
    dukptKeyDerivationType: Optional[
      zio.aws.paymentcryptographydata.model.DukptDerivationType
    ] = Optional.Absent,
    dukptKeyVariant: Optional[
      zio.aws.paymentcryptographydata.model.DukptKeyVariant
    ] = Optional.Absent,
    initializationVector: Optional[HexLength16Or32] = Optional.Absent,
    keySerialNumber: HexLengthBetween10And24,
    mode: Optional[zio.aws.paymentcryptographydata.model.DukptEncryptionMode] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.DukptEncryptionAttributes = {
    import DukptEncryptionAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.DukptEncryptionAttributes
      .builder()
      .optionallyWith(dukptKeyDerivationType.map(value => value.unwrap))(
        _.dukptKeyDerivationType
      )
      .optionallyWith(dukptKeyVariant.map(value => value.unwrap))(
        _.dukptKeyVariant
      )
      .optionallyWith(
        initializationVector.map(value =>
          HexLength16Or32.unwrap(value): java.lang.String
        )
      )(_.initializationVector)
      .keySerialNumber(
        HexLengthBetween10And24.unwrap(keySerialNumber): java.lang.String
      )
      .optionallyWith(mode.map(value => value.unwrap))(_.mode)
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptographydata.model.DukptEncryptionAttributes.ReadOnly =
    zio.aws.paymentcryptographydata.model.DukptEncryptionAttributes
      .wrap(buildAwsValue())
}
object DukptEncryptionAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.DukptEncryptionAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.paymentcryptographydata.model.DukptEncryptionAttributes =
      zio.aws.paymentcryptographydata.model.DukptEncryptionAttributes(
        dukptKeyDerivationType.map(value => value),
        dukptKeyVariant.map(value => value),
        initializationVector.map(value => value),
        keySerialNumber,
        mode.map(value => value)
      )
    def dukptKeyDerivationType
        : Optional[zio.aws.paymentcryptographydata.model.DukptDerivationType]
    def dukptKeyVariant
        : Optional[zio.aws.paymentcryptographydata.model.DukptKeyVariant]
    def initializationVector: Optional[HexLength16Or32]
    def keySerialNumber: HexLengthBetween10And24
    def mode
        : Optional[zio.aws.paymentcryptographydata.model.DukptEncryptionMode]
    def getDukptKeyDerivationType: ZIO[
      Any,
      AwsError,
      zio.aws.paymentcryptographydata.model.DukptDerivationType
    ] = AwsError.unwrapOptionField(
      "dukptKeyDerivationType",
      dukptKeyDerivationType
    )
    def getDukptKeyVariant: ZIO[
      Any,
      AwsError,
      zio.aws.paymentcryptographydata.model.DukptKeyVariant
    ] = AwsError.unwrapOptionField("dukptKeyVariant", dukptKeyVariant)
    def getInitializationVector: ZIO[Any, AwsError, HexLength16Or32] =
      AwsError.unwrapOptionField("initializationVector", initializationVector)
    def getKeySerialNumber: ZIO[Any, Nothing, HexLengthBetween10And24] =
      ZIO.succeed(keySerialNumber)
    def getMode: ZIO[
      Any,
      AwsError,
      zio.aws.paymentcryptographydata.model.DukptEncryptionMode
    ] = AwsError.unwrapOptionField("mode", mode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.DukptEncryptionAttributes
  ) extends zio.aws.paymentcryptographydata.model.DukptEncryptionAttributes.ReadOnly {
    override val dukptKeyDerivationType
        : Optional[zio.aws.paymentcryptographydata.model.DukptDerivationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dukptKeyDerivationType())
        .map(value =>
          zio.aws.paymentcryptographydata.model.DukptDerivationType.wrap(value)
        )
    override val dukptKeyVariant
        : Optional[zio.aws.paymentcryptographydata.model.DukptKeyVariant] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dukptKeyVariant())
        .map(value =>
          zio.aws.paymentcryptographydata.model.DukptKeyVariant.wrap(value)
        )
    override val initializationVector: Optional[HexLength16Or32] =
      zio.aws.core.internal
        .optionalFromNullable(impl.initializationVector())
        .map(value =>
          zio.aws.paymentcryptographydata.model.primitives
            .HexLength16Or32(value)
        )
    override val keySerialNumber: HexLengthBetween10And24 =
      zio.aws.paymentcryptographydata.model.primitives
        .HexLengthBetween10And24(impl.keySerialNumber())
    override val mode
        : Optional[zio.aws.paymentcryptographydata.model.DukptEncryptionMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mode())
        .map(value =>
          zio.aws.paymentcryptographydata.model.DukptEncryptionMode.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.DukptEncryptionAttributes
  ): zio.aws.paymentcryptographydata.model.DukptEncryptionAttributes.ReadOnly =
    new Wrapper(impl)
}
