package zio.aws.paymentcryptographydata.model
import scala.jdk.CollectionConverters.*
sealed trait DukptDerivationType {
  def unwrap: software.amazon.awssdk.services.paymentcryptographydata.model.DukptDerivationType
}
object DukptDerivationType {
  def wrap(
      value: software.amazon.awssdk.services.paymentcryptographydata.model.DukptDerivationType
  ): zio.aws.paymentcryptographydata.model.DukptDerivationType = value match {
    case software.amazon.awssdk.services.paymentcryptographydata.model.DukptDerivationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.paymentcryptographydata.model.DukptDerivationType.TDES_2_KEY =>
      val r = TDES_2KEY
      r
    case software.amazon.awssdk.services.paymentcryptographydata.model.DukptDerivationType.TDES_3_KEY =>
      val r = TDES_3KEY
      r
    case software.amazon.awssdk.services.paymentcryptographydata.model.DukptDerivationType.AES_128 =>
      val r = AES_128
      r
    case software.amazon.awssdk.services.paymentcryptographydata.model.DukptDerivationType.AES_192 =>
      val r = AES_192
      r
    case software.amazon.awssdk.services.paymentcryptographydata.model.DukptDerivationType.AES_256 =>
      val r = AES_256
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.paymentcryptographydata.model.DukptDerivationType {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptographydata.model.DukptDerivationType =
      software.amazon.awssdk.services.paymentcryptographydata.model.DukptDerivationType.UNKNOWN_TO_SDK_VERSION
  }
  case object TDES_2KEY
      extends zio.aws.paymentcryptographydata.model.DukptDerivationType {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptographydata.model.DukptDerivationType =
      software.amazon.awssdk.services.paymentcryptographydata.model.DukptDerivationType.TDES_2_KEY
  }
  case object TDES_3KEY
      extends zio.aws.paymentcryptographydata.model.DukptDerivationType {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptographydata.model.DukptDerivationType =
      software.amazon.awssdk.services.paymentcryptographydata.model.DukptDerivationType.TDES_3_KEY
  }
  case object AES_128
      extends zio.aws.paymentcryptographydata.model.DukptDerivationType {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptographydata.model.DukptDerivationType =
      software.amazon.awssdk.services.paymentcryptographydata.model.DukptDerivationType.AES_128
  }
  case object AES_192
      extends zio.aws.paymentcryptographydata.model.DukptDerivationType {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptographydata.model.DukptDerivationType =
      software.amazon.awssdk.services.paymentcryptographydata.model.DukptDerivationType.AES_192
  }
  case object AES_256
      extends zio.aws.paymentcryptographydata.model.DukptDerivationType {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptographydata.model.DukptDerivationType =
      software.amazon.awssdk.services.paymentcryptographydata.model.DukptDerivationType.AES_256
  }
}
