package zio.aws.paymentcryptographydata.model
import zio.aws.paymentcryptographydata.model.primitives.HexLengthBetween10And24
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DukptAttributes(
    dukptDerivationType: zio.aws.paymentcryptographydata.model.DukptDerivationType,
    keySerialNumber: HexLengthBetween10And24
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.DukptAttributes = {
    import DukptAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.DukptAttributes
      .builder()
      .dukptDerivationType(dukptDerivationType.unwrap)
      .keySerialNumber(
        HexLengthBetween10And24.unwrap(keySerialNumber): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptographydata.model.DukptAttributes.ReadOnly =
    zio.aws.paymentcryptographydata.model.DukptAttributes.wrap(buildAwsValue())
}
object DukptAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.DukptAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptographydata.model.DukptAttributes =
      zio.aws.paymentcryptographydata.model
        .DukptAttributes(dukptDerivationType, keySerialNumber)
    def dukptDerivationType
        : zio.aws.paymentcryptographydata.model.DukptDerivationType
    def keySerialNumber: HexLengthBetween10And24
    def getDukptDerivationType: ZIO[
      Any,
      Nothing,
      zio.aws.paymentcryptographydata.model.DukptDerivationType
    ] = ZIO.succeed(dukptDerivationType)
    def getKeySerialNumber: ZIO[Any, Nothing, HexLengthBetween10And24] =
      ZIO.succeed(keySerialNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.DukptAttributes
  ) extends zio.aws.paymentcryptographydata.model.DukptAttributes.ReadOnly {
    override val dukptDerivationType
        : zio.aws.paymentcryptographydata.model.DukptDerivationType =
      zio.aws.paymentcryptographydata.model.DukptDerivationType
        .wrap(impl.dukptDerivationType())
    override val keySerialNumber: HexLengthBetween10And24 =
      zio.aws.paymentcryptographydata.model.primitives
        .HexLengthBetween10And24(impl.keySerialNumber())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.DukptAttributes
  ): zio.aws.paymentcryptographydata.model.DukptAttributes.ReadOnly =
    new Wrapper(impl)
}
