package zio.aws.paymentcryptographydata.model
import zio.aws.paymentcryptographydata.model.primitives.{
  HexEvenLengthBetween16And4096,
  KeyCheckValue,
  KeyArn
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DecryptDataResponse(
    keyArn: KeyArn,
    keyCheckValue: KeyCheckValue,
    plainText: HexEvenLengthBetween16And4096
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.DecryptDataResponse = {
    import DecryptDataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.DecryptDataResponse
      .builder()
      .keyArn(KeyArn.unwrap(keyArn): java.lang.String)
      .keyCheckValue(KeyCheckValue.unwrap(keyCheckValue): java.lang.String)
      .plainText(
        HexEvenLengthBetween16And4096.unwrap(plainText): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptographydata.model.DecryptDataResponse.ReadOnly =
    zio.aws.paymentcryptographydata.model.DecryptDataResponse
      .wrap(buildAwsValue())
}
object DecryptDataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.DecryptDataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptographydata.model.DecryptDataResponse =
      zio.aws.paymentcryptographydata.model
        .DecryptDataResponse(keyArn, keyCheckValue, plainText)
    def keyArn: KeyArn
    def keyCheckValue: KeyCheckValue
    def plainText: HexEvenLengthBetween16And4096
    def getKeyArn: ZIO[Any, Nothing, KeyArn] = ZIO.succeed(keyArn)
    def getKeyCheckValue: ZIO[Any, Nothing, KeyCheckValue] =
      ZIO.succeed(keyCheckValue)
    def getPlainText: ZIO[Any, Nothing, HexEvenLengthBetween16And4096] =
      ZIO.succeed(plainText)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.DecryptDataResponse
  ) extends zio.aws.paymentcryptographydata.model.DecryptDataResponse.ReadOnly {
    override val keyArn: KeyArn =
      zio.aws.paymentcryptographydata.model.primitives.KeyArn(impl.keyArn())
    override val keyCheckValue: KeyCheckValue =
      zio.aws.paymentcryptographydata.model.primitives
        .KeyCheckValue(impl.keyCheckValue())
    override val plainText: HexEvenLengthBetween16And4096 =
      zio.aws.paymentcryptographydata.model.primitives
        .HexEvenLengthBetween16And4096(impl.plainText())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.DecryptDataResponse
  ): zio.aws.paymentcryptographydata.model.DecryptDataResponse.ReadOnly =
    new Wrapper(impl)
}
