package zio.aws.paymentcryptographydata.model
import zio.aws.paymentcryptographydata.model.primitives.{
  HexLengthBetween1And16,
  HexLengthEquals8
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CryptogramVerificationArpcMethod2(
    cardStatusUpdate: HexLengthEquals8,
    proprietaryAuthenticationData: Optional[HexLengthBetween1And16] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.CryptogramVerificationArpcMethod2 = {
    import CryptogramVerificationArpcMethod2.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.CryptogramVerificationArpcMethod2
      .builder()
      .cardStatusUpdate(
        HexLengthEquals8.unwrap(cardStatusUpdate): java.lang.String
      )
      .optionallyWith(
        proprietaryAuthenticationData.map(value =>
          HexLengthBetween1And16.unwrap(value): java.lang.String
        )
      )(_.proprietaryAuthenticationData)
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptographydata.model.CryptogramVerificationArpcMethod2.ReadOnly =
    zio.aws.paymentcryptographydata.model.CryptogramVerificationArpcMethod2
      .wrap(buildAwsValue())
}
object CryptogramVerificationArpcMethod2 {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.CryptogramVerificationArpcMethod2
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.paymentcryptographydata.model.CryptogramVerificationArpcMethod2 =
      zio.aws.paymentcryptographydata.model.CryptogramVerificationArpcMethod2(
        cardStatusUpdate,
        proprietaryAuthenticationData.map(value => value)
      )
    def cardStatusUpdate: HexLengthEquals8
    def proprietaryAuthenticationData: Optional[HexLengthBetween1And16]
    def getCardStatusUpdate: ZIO[Any, Nothing, HexLengthEquals8] =
      ZIO.succeed(cardStatusUpdate)
    def getProprietaryAuthenticationData
        : ZIO[Any, AwsError, HexLengthBetween1And16] =
      AwsError.unwrapOptionField(
        "proprietaryAuthenticationData",
        proprietaryAuthenticationData
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.CryptogramVerificationArpcMethod2
  ) extends zio.aws.paymentcryptographydata.model.CryptogramVerificationArpcMethod2.ReadOnly {
    override val cardStatusUpdate: HexLengthEquals8 =
      zio.aws.paymentcryptographydata.model.primitives
        .HexLengthEquals8(impl.cardStatusUpdate())
    override val proprietaryAuthenticationData
        : Optional[HexLengthBetween1And16] = zio.aws.core.internal
      .optionalFromNullable(impl.proprietaryAuthenticationData())
      .map(value =>
        zio.aws.paymentcryptographydata.model.primitives
          .HexLengthBetween1And16(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.CryptogramVerificationArpcMethod2
  ): zio.aws.paymentcryptographydata.model.CryptogramVerificationArpcMethod2.ReadOnly =
    new Wrapper(impl)
}
