package zio.aws.paymentcryptographydata.model
import zio.aws.paymentcryptographydata.model.primitives.{
  HexLengthBetween2And8,
  HexLengthEquals2,
  HexLengthBetween2And4
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CardHolderVerificationValue(
    applicationTransactionCounter: HexLengthBetween2And4,
    panSequenceNumber: HexLengthEquals2,
    unpredictableNumber: HexLengthBetween2And8
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.CardHolderVerificationValue = {
    import CardHolderVerificationValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.CardHolderVerificationValue
      .builder()
      .applicationTransactionCounter(
        HexLengthBetween2And4.unwrap(
          applicationTransactionCounter
        ): java.lang.String
      )
      .panSequenceNumber(
        HexLengthEquals2.unwrap(panSequenceNumber): java.lang.String
      )
      .unpredictableNumber(
        HexLengthBetween2And8.unwrap(unpredictableNumber): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptographydata.model.CardHolderVerificationValue.ReadOnly =
    zio.aws.paymentcryptographydata.model.CardHolderVerificationValue
      .wrap(buildAwsValue())
}
object CardHolderVerificationValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.CardHolderVerificationValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.paymentcryptographydata.model.CardHolderVerificationValue =
      zio.aws.paymentcryptographydata.model.CardHolderVerificationValue(
        applicationTransactionCounter,
        panSequenceNumber,
        unpredictableNumber
      )
    def applicationTransactionCounter: HexLengthBetween2And4
    def panSequenceNumber: HexLengthEquals2
    def unpredictableNumber: HexLengthBetween2And8
    def getApplicationTransactionCounter
        : ZIO[Any, Nothing, HexLengthBetween2And4] =
      ZIO.succeed(applicationTransactionCounter)
    def getPanSequenceNumber: ZIO[Any, Nothing, HexLengthEquals2] =
      ZIO.succeed(panSequenceNumber)
    def getUnpredictableNumber: ZIO[Any, Nothing, HexLengthBetween2And8] =
      ZIO.succeed(unpredictableNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.CardHolderVerificationValue
  ) extends zio.aws.paymentcryptographydata.model.CardHolderVerificationValue.ReadOnly {
    override val applicationTransactionCounter: HexLengthBetween2And4 =
      zio.aws.paymentcryptographydata.model.primitives
        .HexLengthBetween2And4(impl.applicationTransactionCounter())
    override val panSequenceNumber: HexLengthEquals2 =
      zio.aws.paymentcryptographydata.model.primitives
        .HexLengthEquals2(impl.panSequenceNumber())
    override val unpredictableNumber: HexLengthBetween2And8 =
      zio.aws.paymentcryptographydata.model.primitives
        .HexLengthBetween2And8(impl.unpredictableNumber())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.CardHolderVerificationValue
  ): zio.aws.paymentcryptographydata.model.CardHolderVerificationValue.ReadOnly =
    new Wrapper(impl)
}
