package zio.aws.paymentcryptographydata.model
import zio.aws.paymentcryptographydata.model.primitives.NumberLengthEquals4
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AmexCardSecurityCodeVersion1(
    cardExpiryDate: NumberLengthEquals4
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.AmexCardSecurityCodeVersion1 = {
    import AmexCardSecurityCodeVersion1.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.AmexCardSecurityCodeVersion1
      .builder()
      .cardExpiryDate(
        NumberLengthEquals4.unwrap(cardExpiryDate): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptographydata.model.AmexCardSecurityCodeVersion1.ReadOnly =
    zio.aws.paymentcryptographydata.model.AmexCardSecurityCodeVersion1
      .wrap(buildAwsValue())
}
object AmexCardSecurityCodeVersion1 {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.AmexCardSecurityCodeVersion1
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.paymentcryptographydata.model.AmexCardSecurityCodeVersion1 =
      zio.aws.paymentcryptographydata.model
        .AmexCardSecurityCodeVersion1(cardExpiryDate)
    def cardExpiryDate: NumberLengthEquals4
    def getCardExpiryDate: ZIO[Any, Nothing, NumberLengthEquals4] =
      ZIO.succeed(cardExpiryDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.AmexCardSecurityCodeVersion1
  ) extends zio.aws.paymentcryptographydata.model.AmexCardSecurityCodeVersion1.ReadOnly {
    override val cardExpiryDate: NumberLengthEquals4 =
      zio.aws.paymentcryptographydata.model.primitives
        .NumberLengthEquals4(impl.cardExpiryDate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.AmexCardSecurityCodeVersion1
  ): zio.aws.paymentcryptographydata.model.AmexCardSecurityCodeVersion1.ReadOnly =
    new Wrapper(impl)
}
