package zio.aws.paymentcryptographydata.model
import zio.aws.paymentcryptographydata.model.primitives.{
  NumberLengthBetween12And19,
  HexLengthEquals2,
  HexLengthBetween2And4
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SessionKeyEmv2000(
    applicationTransactionCounter: HexLengthBetween2And4,
    panSequenceNumber: HexLengthEquals2,
    primaryAccountNumber: NumberLengthBetween12And19
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyEmv2000 = {
    import SessionKeyEmv2000.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyEmv2000
      .builder()
      .applicationTransactionCounter(
        HexLengthBetween2And4.unwrap(
          applicationTransactionCounter
        ): java.lang.String
      )
      .panSequenceNumber(
        HexLengthEquals2.unwrap(panSequenceNumber): java.lang.String
      )
      .primaryAccountNumber(
        NumberLengthBetween12And19.unwrap(
          primaryAccountNumber
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptographydata.model.SessionKeyEmv2000.ReadOnly =
    zio.aws.paymentcryptographydata.model.SessionKeyEmv2000
      .wrap(buildAwsValue())
}
object SessionKeyEmv2000 {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyEmv2000
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptographydata.model.SessionKeyEmv2000 =
      zio.aws.paymentcryptographydata.model.SessionKeyEmv2000(
        applicationTransactionCounter,
        panSequenceNumber,
        primaryAccountNumber
      )
    def applicationTransactionCounter: HexLengthBetween2And4
    def panSequenceNumber: HexLengthEquals2
    def primaryAccountNumber: NumberLengthBetween12And19
    def getApplicationTransactionCounter
        : ZIO[Any, Nothing, HexLengthBetween2And4] =
      ZIO.succeed(applicationTransactionCounter)
    def getPanSequenceNumber: ZIO[Any, Nothing, HexLengthEquals2] =
      ZIO.succeed(panSequenceNumber)
    def getPrimaryAccountNumber: ZIO[Any, Nothing, NumberLengthBetween12And19] =
      ZIO.succeed(primaryAccountNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyEmv2000
  ) extends zio.aws.paymentcryptographydata.model.SessionKeyEmv2000.ReadOnly {
    override val applicationTransactionCounter: HexLengthBetween2And4 =
      zio.aws.paymentcryptographydata.model.primitives
        .HexLengthBetween2And4(impl.applicationTransactionCounter())
    override val panSequenceNumber: HexLengthEquals2 =
      zio.aws.paymentcryptographydata.model.primitives
        .HexLengthEquals2(impl.panSequenceNumber())
    override val primaryAccountNumber: NumberLengthBetween12And19 =
      zio.aws.paymentcryptographydata.model.primitives
        .NumberLengthBetween12And19(impl.primaryAccountNumber())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyEmv2000
  ): zio.aws.paymentcryptographydata.model.SessionKeyEmv2000.ReadOnly =
    new Wrapper(impl)
}
