package zio.aws.paymentcryptographydata.model
import scala.jdk.CollectionConverters._
sealed trait SessionKeyDerivationMode {
  def unwrap: software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyDerivationMode
}
object SessionKeyDerivationMode {
  def wrap(
      value: software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyDerivationMode
  ): zio.aws.paymentcryptographydata.model.SessionKeyDerivationMode =
    value match {
      case software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyDerivationMode.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyDerivationMode.EMV_COMMON_SESSION_KEY =>
        val r = EMV_COMMON_SESSION_KEY
        r
      case software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyDerivationMode.EMV2000 =>
        val r = EMV2000
        r
      case software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyDerivationMode.AMEX =>
        val r = AMEX
        r
      case software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyDerivationMode.MASTERCARD_SESSION_KEY =>
        val r = MASTERCARD_SESSION_KEY
        r
      case software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyDerivationMode.VISA =>
        val r = VISA
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.paymentcryptographydata.model.SessionKeyDerivationMode {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyDerivationMode =
      software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyDerivationMode.UNKNOWN_TO_SDK_VERSION
  }
  case object EMV_COMMON_SESSION_KEY
      extends zio.aws.paymentcryptographydata.model.SessionKeyDerivationMode {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyDerivationMode =
      software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyDerivationMode.EMV_COMMON_SESSION_KEY
  }
  case object EMV2000
      extends zio.aws.paymentcryptographydata.model.SessionKeyDerivationMode {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyDerivationMode =
      software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyDerivationMode.EMV2000
  }
  case object AMEX
      extends zio.aws.paymentcryptographydata.model.SessionKeyDerivationMode {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyDerivationMode =
      software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyDerivationMode.AMEX
  }
  case object MASTERCARD_SESSION_KEY
      extends zio.aws.paymentcryptographydata.model.SessionKeyDerivationMode {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyDerivationMode =
      software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyDerivationMode.MASTERCARD_SESSION_KEY
  }
  case object VISA
      extends zio.aws.paymentcryptographydata.model.SessionKeyDerivationMode {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyDerivationMode =
      software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyDerivationMode.VISA
  }
}
