package zio.aws.paymentcryptographydata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ReEncryptionAttributes(
    dukpt: Optional[
      zio.aws.paymentcryptographydata.model.DukptEncryptionAttributes
    ] = Optional.Absent,
    symmetric: Optional[
      zio.aws.paymentcryptographydata.model.SymmetricEncryptionAttributes
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.ReEncryptionAttributes = {
    import ReEncryptionAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.ReEncryptionAttributes
      .builder()
      .optionallyWith(dukpt.map(value => value.buildAwsValue()))(_.dukpt)
      .optionallyWith(symmetric.map(value => value.buildAwsValue()))(
        _.symmetric
      )
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptographydata.model.ReEncryptionAttributes.ReadOnly =
    zio.aws.paymentcryptographydata.model.ReEncryptionAttributes
      .wrap(buildAwsValue())
}
object ReEncryptionAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.ReEncryptionAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.paymentcryptographydata.model.ReEncryptionAttributes =
      zio.aws.paymentcryptographydata.model.ReEncryptionAttributes(
        dukpt.map(value => value.asEditable),
        symmetric.map(value => value.asEditable)
      )
    def dukpt: Optional[
      zio.aws.paymentcryptographydata.model.DukptEncryptionAttributes.ReadOnly
    ]
    def symmetric: Optional[
      zio.aws.paymentcryptographydata.model.SymmetricEncryptionAttributes.ReadOnly
    ]
    def getDukpt: ZIO[
      Any,
      AwsError,
      zio.aws.paymentcryptographydata.model.DukptEncryptionAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("dukpt", dukpt)
    def getSymmetric: ZIO[
      Any,
      AwsError,
      zio.aws.paymentcryptographydata.model.SymmetricEncryptionAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("symmetric", symmetric)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.ReEncryptionAttributes
  ) extends zio.aws.paymentcryptographydata.model.ReEncryptionAttributes.ReadOnly {
    override val dukpt: Optional[
      zio.aws.paymentcryptographydata.model.DukptEncryptionAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dukpt())
      .map(value =>
        zio.aws.paymentcryptographydata.model.DukptEncryptionAttributes
          .wrap(value)
      )
    override val symmetric: Optional[
      zio.aws.paymentcryptographydata.model.SymmetricEncryptionAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.symmetric())
      .map(value =>
        zio.aws.paymentcryptographydata.model.SymmetricEncryptionAttributes
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.ReEncryptionAttributes
  ): zio.aws.paymentcryptographydata.model.ReEncryptionAttributes.ReadOnly =
    new Wrapper(impl)
}
