package zio.aws.paymentcryptographydata.model
import scala.jdk.CollectionConverters._
sealed trait MacAlgorithm {
  def unwrap: software.amazon.awssdk.services.paymentcryptographydata.model.MacAlgorithm
}
object MacAlgorithm {
  def wrap(
      value: software.amazon.awssdk.services.paymentcryptographydata.model.MacAlgorithm
  ): zio.aws.paymentcryptographydata.model.MacAlgorithm = value match {
    case software.amazon.awssdk.services.paymentcryptographydata.model.MacAlgorithm.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.paymentcryptographydata.model.MacAlgorithm.ISO9797_ALGORITHM1 =>
      val r = ISO9797_ALGORITHM1
      r
    case software.amazon.awssdk.services.paymentcryptographydata.model.MacAlgorithm.ISO9797_ALGORITHM3 =>
      val r = ISO9797_ALGORITHM3
      r
    case software.amazon.awssdk.services.paymentcryptographydata.model.MacAlgorithm.CMAC =>
      val r = CMAC
      r
    case software.amazon.awssdk.services.paymentcryptographydata.model.MacAlgorithm.HMAC_SHA224 =>
      val r = HMAC_SHA224
      r
    case software.amazon.awssdk.services.paymentcryptographydata.model.MacAlgorithm.HMAC_SHA256 =>
      val r = HMAC_SHA256
      r
    case software.amazon.awssdk.services.paymentcryptographydata.model.MacAlgorithm.HMAC_SHA384 =>
      val r = HMAC_SHA384
      r
    case software.amazon.awssdk.services.paymentcryptographydata.model.MacAlgorithm.HMAC_SHA512 =>
      val r = HMAC_SHA512
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.paymentcryptographydata.model.MacAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptographydata.model.MacAlgorithm =
      software.amazon.awssdk.services.paymentcryptographydata.model.MacAlgorithm.UNKNOWN_TO_SDK_VERSION
  }
  case object ISO9797_ALGORITHM1
      extends zio.aws.paymentcryptographydata.model.MacAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptographydata.model.MacAlgorithm =
      software.amazon.awssdk.services.paymentcryptographydata.model.MacAlgorithm.ISO9797_ALGORITHM1
  }
  case object ISO9797_ALGORITHM3
      extends zio.aws.paymentcryptographydata.model.MacAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptographydata.model.MacAlgorithm =
      software.amazon.awssdk.services.paymentcryptographydata.model.MacAlgorithm.ISO9797_ALGORITHM3
  }
  case object CMAC extends zio.aws.paymentcryptographydata.model.MacAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptographydata.model.MacAlgorithm =
      software.amazon.awssdk.services.paymentcryptographydata.model.MacAlgorithm.CMAC
  }
  case object HMAC_SHA224
      extends zio.aws.paymentcryptographydata.model.MacAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptographydata.model.MacAlgorithm =
      software.amazon.awssdk.services.paymentcryptographydata.model.MacAlgorithm.HMAC_SHA224
  }
  case object HMAC_SHA256
      extends zio.aws.paymentcryptographydata.model.MacAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptographydata.model.MacAlgorithm =
      software.amazon.awssdk.services.paymentcryptographydata.model.MacAlgorithm.HMAC_SHA256
  }
  case object HMAC_SHA384
      extends zio.aws.paymentcryptographydata.model.MacAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptographydata.model.MacAlgorithm =
      software.amazon.awssdk.services.paymentcryptographydata.model.MacAlgorithm.HMAC_SHA384
  }
  case object HMAC_SHA512
      extends zio.aws.paymentcryptographydata.model.MacAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptographydata.model.MacAlgorithm =
      software.amazon.awssdk.services.paymentcryptographydata.model.MacAlgorithm.HMAC_SHA512
  }
}
