package zio.aws.paymentcryptographydata.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.paymentcryptographydata.model.primitives.{
  HexEvenLengthBetween2And4096,
  IntegerRangeBetween4And16,
  KeyArnOrKeyAliasType
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GenerateMacRequest(
    generationAttributes: zio.aws.paymentcryptographydata.model.MacAttributes,
    keyIdentifier: KeyArnOrKeyAliasType,
    macLength: Optional[IntegerRangeBetween4And16] = Optional.Absent,
    messageData: HexEvenLengthBetween2And4096
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.GenerateMacRequest = {
    import GenerateMacRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.GenerateMacRequest
      .builder()
      .generationAttributes(generationAttributes.buildAwsValue())
      .keyIdentifier(
        KeyArnOrKeyAliasType.unwrap(keyIdentifier): java.lang.String
      )
      .optionallyWith(
        macLength.map(value => IntegerRangeBetween4And16.unwrap(value): Integer)
      )(_.macLength)
      .messageData(
        HexEvenLengthBetween2And4096.unwrap(messageData): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptographydata.model.GenerateMacRequest.ReadOnly =
    zio.aws.paymentcryptographydata.model.GenerateMacRequest
      .wrap(buildAwsValue())
}
object GenerateMacRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.GenerateMacRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptographydata.model.GenerateMacRequest =
      zio.aws.paymentcryptographydata.model.GenerateMacRequest(
        generationAttributes.asEditable,
        keyIdentifier,
        macLength.map(value => value),
        messageData
      )
    def generationAttributes
        : zio.aws.paymentcryptographydata.model.MacAttributes.ReadOnly
    def keyIdentifier: KeyArnOrKeyAliasType
    def macLength: Optional[IntegerRangeBetween4And16]
    def messageData: HexEvenLengthBetween2And4096
    def getGenerationAttributes: ZIO[
      Any,
      Nothing,
      zio.aws.paymentcryptographydata.model.MacAttributes.ReadOnly
    ] = ZIO.succeed(generationAttributes)
    def getKeyIdentifier: ZIO[Any, Nothing, KeyArnOrKeyAliasType] =
      ZIO.succeed(keyIdentifier)
    def getMacLength: ZIO[Any, AwsError, IntegerRangeBetween4And16] =
      AwsError.unwrapOptionField("macLength", macLength)
    def getMessageData: ZIO[Any, Nothing, HexEvenLengthBetween2And4096] =
      ZIO.succeed(messageData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.GenerateMacRequest
  ) extends zio.aws.paymentcryptographydata.model.GenerateMacRequest.ReadOnly {
    override val generationAttributes
        : zio.aws.paymentcryptographydata.model.MacAttributes.ReadOnly =
      zio.aws.paymentcryptographydata.model.MacAttributes
        .wrap(impl.generationAttributes())
    override val keyIdentifier: KeyArnOrKeyAliasType =
      zio.aws.paymentcryptographydata.model.primitives
        .KeyArnOrKeyAliasType(impl.keyIdentifier())
    override val macLength: Optional[IntegerRangeBetween4And16] =
      zio.aws.core.internal
        .optionalFromNullable(impl.macLength())
        .map(value =>
          zio.aws.paymentcryptographydata.model.primitives
            .IntegerRangeBetween4And16(value)
        )
    override val messageData: HexEvenLengthBetween2And4096 =
      zio.aws.paymentcryptographydata.model.primitives
        .HexEvenLengthBetween2And4096(impl.messageData())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.GenerateMacRequest
  ): zio.aws.paymentcryptographydata.model.GenerateMacRequest.ReadOnly =
    new Wrapper(impl)
}
