package zio.aws.paymentcryptographydata.model
import zio.aws.paymentcryptographydata.model.primitives.{
  NumberLengthEquals3,
  HexLengthEquals2,
  NumberLengthEquals4,
  HexLengthBetween2And4
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DynamicCardVerificationValue(
    applicationTransactionCounter: HexLengthBetween2And4,
    cardExpiryDate: NumberLengthEquals4,
    panSequenceNumber: HexLengthEquals2,
    serviceCode: NumberLengthEquals3
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.DynamicCardVerificationValue = {
    import DynamicCardVerificationValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.DynamicCardVerificationValue
      .builder()
      .applicationTransactionCounter(
        HexLengthBetween2And4.unwrap(
          applicationTransactionCounter
        ): java.lang.String
      )
      .cardExpiryDate(
        NumberLengthEquals4.unwrap(cardExpiryDate): java.lang.String
      )
      .panSequenceNumber(
        HexLengthEquals2.unwrap(panSequenceNumber): java.lang.String
      )
      .serviceCode(NumberLengthEquals3.unwrap(serviceCode): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptographydata.model.DynamicCardVerificationValue.ReadOnly =
    zio.aws.paymentcryptographydata.model.DynamicCardVerificationValue
      .wrap(buildAwsValue())
}
object DynamicCardVerificationValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.DynamicCardVerificationValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.paymentcryptographydata.model.DynamicCardVerificationValue =
      zio.aws.paymentcryptographydata.model.DynamicCardVerificationValue(
        applicationTransactionCounter,
        cardExpiryDate,
        panSequenceNumber,
        serviceCode
      )
    def applicationTransactionCounter: HexLengthBetween2And4
    def cardExpiryDate: NumberLengthEquals4
    def panSequenceNumber: HexLengthEquals2
    def serviceCode: NumberLengthEquals3
    def getApplicationTransactionCounter
        : ZIO[Any, Nothing, HexLengthBetween2And4] =
      ZIO.succeed(applicationTransactionCounter)
    def getCardExpiryDate: ZIO[Any, Nothing, NumberLengthEquals4] =
      ZIO.succeed(cardExpiryDate)
    def getPanSequenceNumber: ZIO[Any, Nothing, HexLengthEquals2] =
      ZIO.succeed(panSequenceNumber)
    def getServiceCode: ZIO[Any, Nothing, NumberLengthEquals3] =
      ZIO.succeed(serviceCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.DynamicCardVerificationValue
  ) extends zio.aws.paymentcryptographydata.model.DynamicCardVerificationValue.ReadOnly {
    override val applicationTransactionCounter: HexLengthBetween2And4 =
      zio.aws.paymentcryptographydata.model.primitives
        .HexLengthBetween2And4(impl.applicationTransactionCounter())
    override val cardExpiryDate: NumberLengthEquals4 =
      zio.aws.paymentcryptographydata.model.primitives
        .NumberLengthEquals4(impl.cardExpiryDate())
    override val panSequenceNumber: HexLengthEquals2 =
      zio.aws.paymentcryptographydata.model.primitives
        .HexLengthEquals2(impl.panSequenceNumber())
    override val serviceCode: NumberLengthEquals3 =
      zio.aws.paymentcryptographydata.model.primitives
        .NumberLengthEquals3(impl.serviceCode())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.DynamicCardVerificationValue
  ): zio.aws.paymentcryptographydata.model.DynamicCardVerificationValue.ReadOnly =
    new Wrapper(impl)
}
