package zio.aws.paymentcryptographydata.model
import scala.jdk.CollectionConverters._
sealed trait DukptEncryptionMode {
  def unwrap: software.amazon.awssdk.services.paymentcryptographydata.model.DukptEncryptionMode
}
object DukptEncryptionMode {
  def wrap(
      value: software.amazon.awssdk.services.paymentcryptographydata.model.DukptEncryptionMode
  ): zio.aws.paymentcryptographydata.model.DukptEncryptionMode = value match {
    case software.amazon.awssdk.services.paymentcryptographydata.model.DukptEncryptionMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.paymentcryptographydata.model.DukptEncryptionMode.ECB =>
      val r = ECB
      r
    case software.amazon.awssdk.services.paymentcryptographydata.model.DukptEncryptionMode.CBC =>
      val r = CBC
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.paymentcryptographydata.model.DukptEncryptionMode {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptographydata.model.DukptEncryptionMode =
      software.amazon.awssdk.services.paymentcryptographydata.model.DukptEncryptionMode.UNKNOWN_TO_SDK_VERSION
  }
  case object ECB
      extends zio.aws.paymentcryptographydata.model.DukptEncryptionMode {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptographydata.model.DukptEncryptionMode =
      software.amazon.awssdk.services.paymentcryptographydata.model.DukptEncryptionMode.ECB
  }
  case object CBC
      extends zio.aws.paymentcryptographydata.model.DukptEncryptionMode {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptographydata.model.DukptEncryptionMode =
      software.amazon.awssdk.services.paymentcryptographydata.model.DukptEncryptionMode.CBC
  }
}
