package zio.aws.paymentcryptographydata.model
import zio.aws.paymentcryptographydata.model.primitives.{
  HexLengthBetween2And8,
  NumberLengthEquals4,
  HexLengthBetween2And4
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DiscoverDynamicCardVerificationCode(
    applicationTransactionCounter: HexLengthBetween2And4,
    cardExpiryDate: NumberLengthEquals4,
    unpredictableNumber: HexLengthBetween2And8
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.DiscoverDynamicCardVerificationCode = {
    import DiscoverDynamicCardVerificationCode.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.DiscoverDynamicCardVerificationCode
      .builder()
      .applicationTransactionCounter(
        HexLengthBetween2And4.unwrap(
          applicationTransactionCounter
        ): java.lang.String
      )
      .cardExpiryDate(
        NumberLengthEquals4.unwrap(cardExpiryDate): java.lang.String
      )
      .unpredictableNumber(
        HexLengthBetween2And8.unwrap(unpredictableNumber): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptographydata.model.DiscoverDynamicCardVerificationCode.ReadOnly =
    zio.aws.paymentcryptographydata.model.DiscoverDynamicCardVerificationCode
      .wrap(buildAwsValue())
}
object DiscoverDynamicCardVerificationCode {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.DiscoverDynamicCardVerificationCode
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.paymentcryptographydata.model.DiscoverDynamicCardVerificationCode =
      zio.aws.paymentcryptographydata.model.DiscoverDynamicCardVerificationCode(
        applicationTransactionCounter,
        cardExpiryDate,
        unpredictableNumber
      )
    def applicationTransactionCounter: HexLengthBetween2And4
    def cardExpiryDate: NumberLengthEquals4
    def unpredictableNumber: HexLengthBetween2And8
    def getApplicationTransactionCounter
        : ZIO[Any, Nothing, HexLengthBetween2And4] =
      ZIO.succeed(applicationTransactionCounter)
    def getCardExpiryDate: ZIO[Any, Nothing, NumberLengthEquals4] =
      ZIO.succeed(cardExpiryDate)
    def getUnpredictableNumber: ZIO[Any, Nothing, HexLengthBetween2And8] =
      ZIO.succeed(unpredictableNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.DiscoverDynamicCardVerificationCode
  ) extends zio.aws.paymentcryptographydata.model.DiscoverDynamicCardVerificationCode.ReadOnly {
    override val applicationTransactionCounter: HexLengthBetween2And4 =
      zio.aws.paymentcryptographydata.model.primitives
        .HexLengthBetween2And4(impl.applicationTransactionCounter())
    override val cardExpiryDate: NumberLengthEquals4 =
      zio.aws.paymentcryptographydata.model.primitives
        .NumberLengthEquals4(impl.cardExpiryDate())
    override val unpredictableNumber: HexLengthBetween2And8 =
      zio.aws.paymentcryptographydata.model.primitives
        .HexLengthBetween2And8(impl.unpredictableNumber())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.DiscoverDynamicCardVerificationCode
  ): zio.aws.paymentcryptographydata.model.DiscoverDynamicCardVerificationCode.ReadOnly =
    new Wrapper(impl)
}
