package zio.aws.paymentcryptographydata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CryptogramAuthResponse(
    arpcMethod1: Optional[
      zio.aws.paymentcryptographydata.model.CryptogramVerificationArpcMethod1
    ] = Optional.Absent,
    arpcMethod2: Optional[
      zio.aws.paymentcryptographydata.model.CryptogramVerificationArpcMethod2
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.CryptogramAuthResponse = {
    import CryptogramAuthResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.CryptogramAuthResponse
      .builder()
      .optionallyWith(arpcMethod1.map(value => value.buildAwsValue()))(
        _.arpcMethod1
      )
      .optionallyWith(arpcMethod2.map(value => value.buildAwsValue()))(
        _.arpcMethod2
      )
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptographydata.model.CryptogramAuthResponse.ReadOnly =
    zio.aws.paymentcryptographydata.model.CryptogramAuthResponse
      .wrap(buildAwsValue())
}
object CryptogramAuthResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.CryptogramAuthResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.paymentcryptographydata.model.CryptogramAuthResponse =
      zio.aws.paymentcryptographydata.model.CryptogramAuthResponse(
        arpcMethod1.map(value => value.asEditable),
        arpcMethod2.map(value => value.asEditable)
      )
    def arpcMethod1: Optional[
      zio.aws.paymentcryptographydata.model.CryptogramVerificationArpcMethod1.ReadOnly
    ]
    def arpcMethod2: Optional[
      zio.aws.paymentcryptographydata.model.CryptogramVerificationArpcMethod2.ReadOnly
    ]
    def getArpcMethod1: ZIO[
      Any,
      AwsError,
      zio.aws.paymentcryptographydata.model.CryptogramVerificationArpcMethod1.ReadOnly
    ] = AwsError.unwrapOptionField("arpcMethod1", arpcMethod1)
    def getArpcMethod2: ZIO[
      Any,
      AwsError,
      zio.aws.paymentcryptographydata.model.CryptogramVerificationArpcMethod2.ReadOnly
    ] = AwsError.unwrapOptionField("arpcMethod2", arpcMethod2)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.CryptogramAuthResponse
  ) extends zio.aws.paymentcryptographydata.model.CryptogramAuthResponse.ReadOnly {
    override val arpcMethod1: Optional[
      zio.aws.paymentcryptographydata.model.CryptogramVerificationArpcMethod1.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.arpcMethod1())
      .map(value =>
        zio.aws.paymentcryptographydata.model.CryptogramVerificationArpcMethod1
          .wrap(value)
      )
    override val arpcMethod2: Optional[
      zio.aws.paymentcryptographydata.model.CryptogramVerificationArpcMethod2.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.arpcMethod2())
      .map(value =>
        zio.aws.paymentcryptographydata.model.CryptogramVerificationArpcMethod2
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.CryptogramAuthResponse
  ): zio.aws.paymentcryptographydata.model.CryptogramAuthResponse.ReadOnly =
    new Wrapper(impl)
}
