package zio.aws.paymentcryptographydata
import zio.aws.paymentcryptographydata.model.VerifyMacResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import software.amazon.awssdk.services.paymentcryptographydata.PaymentCryptographyDataAsyncClient
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.paymentcryptographydata.model.{
  ReEncryptDataRequest,
  VerifyPinDataRequest,
  VerifyCardValidationDataRequest,
  GenerateMacRequest,
  TranslatePinDataRequest,
  VerifyMacRequest,
  GenerateCardValidationDataRequest,
  DecryptDataRequest,
  GeneratePinDataRequest,
  EncryptDataRequest,
  VerifyAuthRequestCryptogramRequest
}
object PaymentCryptographyDataMock extends Mock[PaymentCryptographyData] {
  object GenerateCardValidationData
      extends Effect[
        GenerateCardValidationDataRequest,
        AwsError,
        zio.aws.paymentcryptographydata.model.GenerateCardValidationDataResponse.ReadOnly
      ]
  object ReEncryptData
      extends Effect[
        ReEncryptDataRequest,
        AwsError,
        zio.aws.paymentcryptographydata.model.ReEncryptDataResponse.ReadOnly
      ]
  object DecryptData
      extends Effect[
        DecryptDataRequest,
        AwsError,
        zio.aws.paymentcryptographydata.model.DecryptDataResponse.ReadOnly
      ]
  object EncryptData
      extends Effect[
        EncryptDataRequest,
        AwsError,
        zio.aws.paymentcryptographydata.model.EncryptDataResponse.ReadOnly
      ]
  object GenerateMac
      extends Effect[
        GenerateMacRequest,
        AwsError,
        zio.aws.paymentcryptographydata.model.GenerateMacResponse.ReadOnly
      ]
  object GeneratePinData
      extends Effect[
        GeneratePinDataRequest,
        AwsError,
        zio.aws.paymentcryptographydata.model.GeneratePinDataResponse.ReadOnly
      ]
  object TranslatePinData
      extends Effect[
        TranslatePinDataRequest,
        AwsError,
        zio.aws.paymentcryptographydata.model.TranslatePinDataResponse.ReadOnly
      ]
  object VerifyMac extends Effect[VerifyMacRequest, AwsError, ReadOnly]
  object VerifyPinData
      extends Effect[
        VerifyPinDataRequest,
        AwsError,
        zio.aws.paymentcryptographydata.model.VerifyPinDataResponse.ReadOnly
      ]
  object VerifyAuthRequestCryptogram
      extends Effect[
        VerifyAuthRequestCryptogramRequest,
        AwsError,
        zio.aws.paymentcryptographydata.model.VerifyAuthRequestCryptogramResponse.ReadOnly
      ]
  object VerifyCardValidationData
      extends Effect[
        VerifyCardValidationDataRequest,
        AwsError,
        zio.aws.paymentcryptographydata.model.VerifyCardValidationDataResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, PaymentCryptographyData] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, PaymentCryptographyData] { rts =>
        zio.ZIO.succeed {
          new PaymentCryptographyData {
            val api: PaymentCryptographyDataAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): PaymentCryptographyData = this
            def generateCardValidationData(
                request: GenerateCardValidationDataRequest
            ): IO[
              AwsError,
              zio.aws.paymentcryptographydata.model.GenerateCardValidationDataResponse.ReadOnly
            ] = proxy(GenerateCardValidationData, request)
            def reEncryptData(request: ReEncryptDataRequest): IO[
              AwsError,
              zio.aws.paymentcryptographydata.model.ReEncryptDataResponse.ReadOnly
            ] = proxy(ReEncryptData, request)
            def decryptData(request: DecryptDataRequest): IO[
              AwsError,
              zio.aws.paymentcryptographydata.model.DecryptDataResponse.ReadOnly
            ] = proxy(DecryptData, request)
            def encryptData(request: EncryptDataRequest): IO[
              AwsError,
              zio.aws.paymentcryptographydata.model.EncryptDataResponse.ReadOnly
            ] = proxy(EncryptData, request)
            def generateMac(request: GenerateMacRequest): IO[
              AwsError,
              zio.aws.paymentcryptographydata.model.GenerateMacResponse.ReadOnly
            ] = proxy(GenerateMac, request)
            def generatePinData(request: GeneratePinDataRequest): IO[
              AwsError,
              zio.aws.paymentcryptographydata.model.GeneratePinDataResponse.ReadOnly
            ] = proxy(GeneratePinData, request)
            def translatePinData(request: TranslatePinDataRequest): IO[
              AwsError,
              zio.aws.paymentcryptographydata.model.TranslatePinDataResponse.ReadOnly
            ] = proxy(TranslatePinData, request)
            def verifyMac(request: VerifyMacRequest): IO[AwsError, ReadOnly] =
              proxy(VerifyMac, request)
            def verifyPinData(request: VerifyPinDataRequest): IO[
              AwsError,
              zio.aws.paymentcryptographydata.model.VerifyPinDataResponse.ReadOnly
            ] = proxy(VerifyPinData, request)
            def verifyAuthRequestCryptogram(
                request: VerifyAuthRequestCryptogramRequest
            ): IO[
              AwsError,
              zio.aws.paymentcryptographydata.model.VerifyAuthRequestCryptogramResponse.ReadOnly
            ] = proxy(VerifyAuthRequestCryptogram, request)
            def verifyCardValidationData(
                request: VerifyCardValidationDataRequest
            ): IO[
              AwsError,
              zio.aws.paymentcryptographydata.model.VerifyCardValidationDataResponse.ReadOnly
            ] = proxy(VerifyCardValidationData, request)
          }
        }
      }
    }
  }
}
