package zio.aws.paymentcryptographydata
import zio.aws.paymentcryptographydata.model.VerifyMacResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.paymentcryptographydata.model.{
  ReEncryptDataResponse,
  ReEncryptDataRequest,
  VerifyPinDataRequest,
  DecryptDataResponse,
  VerifyCardValidationDataRequest,
  VerifyPinDataResponse,
  GenerateMacRequest,
  VerifyCardValidationDataResponse,
  GenerateMacResponse,
  GenerateCardValidationDataResponse,
  EncryptDataResponse,
  TranslatePinDataRequest,
  VerifyMacRequest,
  GenerateCardValidationDataRequest,
  DecryptDataRequest,
  VerifyAuthRequestCryptogramResponse,
  GeneratePinDataRequest,
  EncryptDataRequest,
  TranslatePinDataResponse,
  VerifyMacResponse,
  VerifyAuthRequestCryptogramRequest,
  GeneratePinDataResponse
}
import software.amazon.awssdk.services.paymentcryptographydata.{
  PaymentCryptographyDataAsyncClientBuilder,
  PaymentCryptographyDataAsyncClient
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import scala.jdk.CollectionConverters._
trait PaymentCryptographyData extends AspectSupport[PaymentCryptographyData] {
  val api: PaymentCryptographyDataAsyncClient
  def generateCardValidationData(
      request: zio.aws.paymentcryptographydata.model.GenerateCardValidationDataRequest
  ): IO[
    AwsError,
    zio.aws.paymentcryptographydata.model.GenerateCardValidationDataResponse.ReadOnly
  ]
  def reEncryptData(
      request: zio.aws.paymentcryptographydata.model.ReEncryptDataRequest
  ): IO[
    AwsError,
    zio.aws.paymentcryptographydata.model.ReEncryptDataResponse.ReadOnly
  ]
  def decryptData(
      request: zio.aws.paymentcryptographydata.model.DecryptDataRequest
  ): IO[
    AwsError,
    zio.aws.paymentcryptographydata.model.DecryptDataResponse.ReadOnly
  ]
  def encryptData(
      request: zio.aws.paymentcryptographydata.model.EncryptDataRequest
  ): IO[
    AwsError,
    zio.aws.paymentcryptographydata.model.EncryptDataResponse.ReadOnly
  ]
  def generateMac(
      request: zio.aws.paymentcryptographydata.model.GenerateMacRequest
  ): IO[
    AwsError,
    zio.aws.paymentcryptographydata.model.GenerateMacResponse.ReadOnly
  ]
  def generatePinData(
      request: zio.aws.paymentcryptographydata.model.GeneratePinDataRequest
  ): IO[
    AwsError,
    zio.aws.paymentcryptographydata.model.GeneratePinDataResponse.ReadOnly
  ]
  def translatePinData(
      request: zio.aws.paymentcryptographydata.model.TranslatePinDataRequest
  ): IO[
    AwsError,
    zio.aws.paymentcryptographydata.model.TranslatePinDataResponse.ReadOnly
  ]
  def verifyMac(
      request: zio.aws.paymentcryptographydata.model.VerifyMacRequest
  ): IO[AwsError, ReadOnly]
  def verifyPinData(
      request: zio.aws.paymentcryptographydata.model.VerifyPinDataRequest
  ): IO[
    AwsError,
    zio.aws.paymentcryptographydata.model.VerifyPinDataResponse.ReadOnly
  ]
  def verifyAuthRequestCryptogram(
      request: zio.aws.paymentcryptographydata.model.VerifyAuthRequestCryptogramRequest
  ): IO[
    AwsError,
    zio.aws.paymentcryptographydata.model.VerifyAuthRequestCryptogramResponse.ReadOnly
  ]
  def verifyCardValidationData(
      request: zio.aws.paymentcryptographydata.model.VerifyCardValidationDataRequest
  ): IO[
    AwsError,
    zio.aws.paymentcryptographydata.model.VerifyCardValidationDataResponse.ReadOnly
  ]
}
object PaymentCryptographyData {
  val live: ZLayer[AwsConfig, java.lang.Throwable, PaymentCryptographyData] =
    customized(identity)
  def customized(
      customization: PaymentCryptographyDataAsyncClientBuilder => PaymentCryptographyDataAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, PaymentCryptographyData] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: PaymentCryptographyDataAsyncClientBuilder => PaymentCryptographyDataAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, PaymentCryptographyData] =
    for (
      awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
      builder = PaymentCryptographyDataAsyncClient
        .builder()
        .asyncConfiguration(
          software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
            .builder()
            .advancedOption(
              software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
              executor.asJava
            )
            .build()
        );
      b0 <- awsConfig.configure[
        PaymentCryptographyDataAsyncClient,
        PaymentCryptographyDataAsyncClientBuilder
      ](builder);
      b1 <- awsConfig.configureHttpClient[
        PaymentCryptographyDataAsyncClient,
        PaymentCryptographyDataAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
    )
      yield new PaymentCryptographyDataImpl(
        client,
        AwsCallAspect.identity,
        ZEnvironment.empty
      )
  private class PaymentCryptographyDataImpl[R](
      override val api: PaymentCryptographyDataAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends PaymentCryptographyData
      with AwsServiceBase[R] {
    override val serviceName: String = "PaymentCryptographyData"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): PaymentCryptographyDataImpl[R1] =
      new PaymentCryptographyDataImpl(api, newAspect, r)
    def generateCardValidationData(
        request: zio.aws.paymentcryptographydata.model.GenerateCardValidationDataRequest
    ): IO[
      AwsError,
      zio.aws.paymentcryptographydata.model.GenerateCardValidationDataResponse.ReadOnly
    ] = asyncRequestResponse[
      GenerateCardValidationDataRequest,
      GenerateCardValidationDataResponse
    ]("generateCardValidationData", api.generateCardValidationData)(
      request.buildAwsValue()
    ).map(
      zio.aws.paymentcryptographydata.model.GenerateCardValidationDataResponse.wrap
    ).provideEnvironment(r)
    def reEncryptData(
        request: zio.aws.paymentcryptographydata.model.ReEncryptDataRequest
    ): IO[
      AwsError,
      zio.aws.paymentcryptographydata.model.ReEncryptDataResponse.ReadOnly
    ] = asyncRequestResponse[ReEncryptDataRequest, ReEncryptDataResponse](
      "reEncryptData",
      api.reEncryptData
    )(request.buildAwsValue())
      .map(zio.aws.paymentcryptographydata.model.ReEncryptDataResponse.wrap)
      .provideEnvironment(r)
    def decryptData(
        request: zio.aws.paymentcryptographydata.model.DecryptDataRequest
    ): IO[
      AwsError,
      zio.aws.paymentcryptographydata.model.DecryptDataResponse.ReadOnly
    ] = asyncRequestResponse[DecryptDataRequest, DecryptDataResponse](
      "decryptData",
      api.decryptData
    )(request.buildAwsValue())
      .map(zio.aws.paymentcryptographydata.model.DecryptDataResponse.wrap)
      .provideEnvironment(r)
    def encryptData(
        request: zio.aws.paymentcryptographydata.model.EncryptDataRequest
    ): IO[
      AwsError,
      zio.aws.paymentcryptographydata.model.EncryptDataResponse.ReadOnly
    ] = asyncRequestResponse[EncryptDataRequest, EncryptDataResponse](
      "encryptData",
      api.encryptData
    )(request.buildAwsValue())
      .map(zio.aws.paymentcryptographydata.model.EncryptDataResponse.wrap)
      .provideEnvironment(r)
    def generateMac(
        request: zio.aws.paymentcryptographydata.model.GenerateMacRequest
    ): IO[
      AwsError,
      zio.aws.paymentcryptographydata.model.GenerateMacResponse.ReadOnly
    ] = asyncRequestResponse[GenerateMacRequest, GenerateMacResponse](
      "generateMac",
      api.generateMac
    )(request.buildAwsValue())
      .map(zio.aws.paymentcryptographydata.model.GenerateMacResponse.wrap)
      .provideEnvironment(r)
    def generatePinData(
        request: zio.aws.paymentcryptographydata.model.GeneratePinDataRequest
    ): IO[
      AwsError,
      zio.aws.paymentcryptographydata.model.GeneratePinDataResponse.ReadOnly
    ] = asyncRequestResponse[GeneratePinDataRequest, GeneratePinDataResponse](
      "generatePinData",
      api.generatePinData
    )(request.buildAwsValue())
      .map(zio.aws.paymentcryptographydata.model.GeneratePinDataResponse.wrap)
      .provideEnvironment(r)
    def translatePinData(
        request: zio.aws.paymentcryptographydata.model.TranslatePinDataRequest
    ): IO[
      AwsError,
      zio.aws.paymentcryptographydata.model.TranslatePinDataResponse.ReadOnly
    ] = asyncRequestResponse[TranslatePinDataRequest, TranslatePinDataResponse](
      "translatePinData",
      api.translatePinData
    )(request.buildAwsValue())
      .map(zio.aws.paymentcryptographydata.model.TranslatePinDataResponse.wrap)
      .provideEnvironment(r)
    def verifyMac(
        request: zio.aws.paymentcryptographydata.model.VerifyMacRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[VerifyMacRequest, VerifyMacResponse](
        "verifyMac",
        api.verifyMac
      )(request.buildAwsValue())
        .map(zio.aws.paymentcryptographydata.model.VerifyMacResponse.wrap)
        .provideEnvironment(r)
    def verifyPinData(
        request: zio.aws.paymentcryptographydata.model.VerifyPinDataRequest
    ): IO[
      AwsError,
      zio.aws.paymentcryptographydata.model.VerifyPinDataResponse.ReadOnly
    ] = asyncRequestResponse[VerifyPinDataRequest, VerifyPinDataResponse](
      "verifyPinData",
      api.verifyPinData
    )(request.buildAwsValue())
      .map(zio.aws.paymentcryptographydata.model.VerifyPinDataResponse.wrap)
      .provideEnvironment(r)
    def verifyAuthRequestCryptogram(
        request: zio.aws.paymentcryptographydata.model.VerifyAuthRequestCryptogramRequest
    ): IO[
      AwsError,
      zio.aws.paymentcryptographydata.model.VerifyAuthRequestCryptogramResponse.ReadOnly
    ] = asyncRequestResponse[
      VerifyAuthRequestCryptogramRequest,
      VerifyAuthRequestCryptogramResponse
    ]("verifyAuthRequestCryptogram", api.verifyAuthRequestCryptogram)(
      request.buildAwsValue()
    ).map(
      zio.aws.paymentcryptographydata.model.VerifyAuthRequestCryptogramResponse.wrap
    ).provideEnvironment(r)
    def verifyCardValidationData(
        request: zio.aws.paymentcryptographydata.model.VerifyCardValidationDataRequest
    ): IO[
      AwsError,
      zio.aws.paymentcryptographydata.model.VerifyCardValidationDataResponse.ReadOnly
    ] = asyncRequestResponse[
      VerifyCardValidationDataRequest,
      VerifyCardValidationDataResponse
    ]("verifyCardValidationData", api.verifyCardValidationData)(
      request.buildAwsValue()
    ).map(
      zio.aws.paymentcryptographydata.model.VerifyCardValidationDataResponse.wrap
    ).provideEnvironment(r)
  }
  def generateCardValidationData(
      request: zio.aws.paymentcryptographydata.model.GenerateCardValidationDataRequest
  ): ZIO[
    zio.aws.paymentcryptographydata.PaymentCryptographyData,
    AwsError,
    zio.aws.paymentcryptographydata.model.GenerateCardValidationDataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.generateCardValidationData(request))
  def reEncryptData(
      request: zio.aws.paymentcryptographydata.model.ReEncryptDataRequest
  ): ZIO[
    zio.aws.paymentcryptographydata.PaymentCryptographyData,
    AwsError,
    zio.aws.paymentcryptographydata.model.ReEncryptDataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.reEncryptData(request))
  def decryptData(
      request: zio.aws.paymentcryptographydata.model.DecryptDataRequest
  ): ZIO[
    zio.aws.paymentcryptographydata.PaymentCryptographyData,
    AwsError,
    zio.aws.paymentcryptographydata.model.DecryptDataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.decryptData(request))
  def encryptData(
      request: zio.aws.paymentcryptographydata.model.EncryptDataRequest
  ): ZIO[
    zio.aws.paymentcryptographydata.PaymentCryptographyData,
    AwsError,
    zio.aws.paymentcryptographydata.model.EncryptDataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.encryptData(request))
  def generateMac(
      request: zio.aws.paymentcryptographydata.model.GenerateMacRequest
  ): ZIO[
    zio.aws.paymentcryptographydata.PaymentCryptographyData,
    AwsError,
    zio.aws.paymentcryptographydata.model.GenerateMacResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.generateMac(request))
  def generatePinData(
      request: zio.aws.paymentcryptographydata.model.GeneratePinDataRequest
  ): ZIO[
    zio.aws.paymentcryptographydata.PaymentCryptographyData,
    AwsError,
    zio.aws.paymentcryptographydata.model.GeneratePinDataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.generatePinData(request))
  def translatePinData(
      request: zio.aws.paymentcryptographydata.model.TranslatePinDataRequest
  ): ZIO[
    zio.aws.paymentcryptographydata.PaymentCryptographyData,
    AwsError,
    zio.aws.paymentcryptographydata.model.TranslatePinDataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.translatePinData(request))
  def verifyMac(
      request: zio.aws.paymentcryptographydata.model.VerifyMacRequest
  ): ZIO[
    zio.aws.paymentcryptographydata.PaymentCryptographyData,
    AwsError,
    ReadOnly
  ] = ZIO.serviceWithZIO(_.verifyMac(request))
  def verifyPinData(
      request: zio.aws.paymentcryptographydata.model.VerifyPinDataRequest
  ): ZIO[
    zio.aws.paymentcryptographydata.PaymentCryptographyData,
    AwsError,
    zio.aws.paymentcryptographydata.model.VerifyPinDataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.verifyPinData(request))
  def verifyAuthRequestCryptogram(
      request: zio.aws.paymentcryptographydata.model.VerifyAuthRequestCryptogramRequest
  ): ZIO[
    zio.aws.paymentcryptographydata.PaymentCryptographyData,
    AwsError,
    zio.aws.paymentcryptographydata.model.VerifyAuthRequestCryptogramResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.verifyAuthRequestCryptogram(request))
  def verifyCardValidationData(
      request: zio.aws.paymentcryptographydata.model.VerifyCardValidationDataRequest
  ): ZIO[
    zio.aws.paymentcryptographydata.PaymentCryptographyData,
    AwsError,
    zio.aws.paymentcryptographydata.model.VerifyCardValidationDataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.verifyCardValidationData(request))
}
