package zio.aws.paymentcryptographydata.model
import zio.aws.paymentcryptographydata.model.primitives.{
  KeyCheckValue,
  KeyArn,
  HexLengthBetween1And16
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VerifyAuthRequestCryptogramResponse(
    authResponseValue: Optional[HexLengthBetween1And16] = Optional.Absent,
    keyArn: KeyArn,
    keyCheckValue: KeyCheckValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.VerifyAuthRequestCryptogramResponse = {
    import VerifyAuthRequestCryptogramResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.VerifyAuthRequestCryptogramResponse
      .builder()
      .optionallyWith(
        authResponseValue.map(value =>
          HexLengthBetween1And16.unwrap(value): java.lang.String
        )
      )(_.authResponseValue)
      .keyArn(KeyArn.unwrap(keyArn): java.lang.String)
      .keyCheckValue(KeyCheckValue.unwrap(keyCheckValue): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptographydata.model.VerifyAuthRequestCryptogramResponse.ReadOnly =
    zio.aws.paymentcryptographydata.model.VerifyAuthRequestCryptogramResponse
      .wrap(buildAwsValue())
}
object VerifyAuthRequestCryptogramResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.VerifyAuthRequestCryptogramResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.paymentcryptographydata.model.VerifyAuthRequestCryptogramResponse =
      zio.aws.paymentcryptographydata.model.VerifyAuthRequestCryptogramResponse(
        authResponseValue.map(value => value),
        keyArn,
        keyCheckValue
      )
    def authResponseValue: Optional[HexLengthBetween1And16]
    def keyArn: KeyArn
    def keyCheckValue: KeyCheckValue
    def getAuthResponseValue: ZIO[Any, AwsError, HexLengthBetween1And16] =
      AwsError.unwrapOptionField("authResponseValue", authResponseValue)
    def getKeyArn: ZIO[Any, Nothing, KeyArn] = ZIO.succeed(keyArn)
    def getKeyCheckValue: ZIO[Any, Nothing, KeyCheckValue] =
      ZIO.succeed(keyCheckValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.VerifyAuthRequestCryptogramResponse
  ) extends zio.aws.paymentcryptographydata.model.VerifyAuthRequestCryptogramResponse.ReadOnly {
    override val authResponseValue: Optional[HexLengthBetween1And16] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authResponseValue())
        .map(value =>
          zio.aws.paymentcryptographydata.model.primitives
            .HexLengthBetween1And16(value)
        )
    override val keyArn: KeyArn =
      zio.aws.paymentcryptographydata.model.primitives.KeyArn(impl.keyArn())
    override val keyCheckValue: KeyCheckValue =
      zio.aws.paymentcryptographydata.model.primitives
        .KeyCheckValue(impl.keyCheckValue())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.VerifyAuthRequestCryptogramResponse
  ): zio.aws.paymentcryptographydata.model.VerifyAuthRequestCryptogramResponse.ReadOnly =
    new Wrapper(impl)
}
