package zio.aws.paymentcryptographydata.model
import zio.aws.paymentcryptographydata.model.primitives.NumberLengthBetween4And12
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PinData(
    pinOffset: Optional[NumberLengthBetween4And12] = Optional.Absent,
    verificationValue: Optional[NumberLengthBetween4And12] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.PinData = {
    import PinData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.PinData
      .builder()
      .optionallyWith(
        pinOffset.map(value =>
          NumberLengthBetween4And12.unwrap(value): java.lang.String
        )
      )(_.pinOffset)
      .optionallyWith(
        verificationValue.map(value =>
          NumberLengthBetween4And12.unwrap(value): java.lang.String
        )
      )(_.verificationValue)
      .build()
  }
  def asReadOnly: zio.aws.paymentcryptographydata.model.PinData.ReadOnly =
    zio.aws.paymentcryptographydata.model.PinData.wrap(buildAwsValue())
}
object PinData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.PinData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptographydata.model.PinData =
      zio.aws.paymentcryptographydata.model.PinData(
        pinOffset.map(value => value),
        verificationValue.map(value => value)
      )
    def pinOffset: Optional[NumberLengthBetween4And12]
    def verificationValue: Optional[NumberLengthBetween4And12]
    def getPinOffset: ZIO[Any, AwsError, NumberLengthBetween4And12] =
      AwsError.unwrapOptionField("pinOffset", pinOffset)
    def getVerificationValue: ZIO[Any, AwsError, NumberLengthBetween4And12] =
      AwsError.unwrapOptionField("verificationValue", verificationValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.PinData
  ) extends zio.aws.paymentcryptographydata.model.PinData.ReadOnly {
    override val pinOffset: Optional[NumberLengthBetween4And12] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pinOffset())
        .map(value =>
          zio.aws.paymentcryptographydata.model.primitives
            .NumberLengthBetween4And12(value)
        )
    override val verificationValue: Optional[NumberLengthBetween4And12] =
      zio.aws.core.internal
        .optionalFromNullable(impl.verificationValue())
        .map(value =>
          zio.aws.paymentcryptographydata.model.primitives
            .NumberLengthBetween4And12(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.PinData
  ): zio.aws.paymentcryptographydata.model.PinData.ReadOnly = new Wrapper(impl)
}
