package zio.aws.paymentcryptographydata.model
import java.lang.Integer
import zio.aws.paymentcryptographydata.model.primitives.{
  IntegerRangeBetween0And9,
  HexLengthBetween16And32
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class VisaPinVerificationValue(
    encryptedPinBlock: HexLengthBetween16And32,
    pinVerificationKeyIndex: IntegerRangeBetween0And9
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.VisaPinVerificationValue = {
    import VisaPinVerificationValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.VisaPinVerificationValue
      .builder()
      .encryptedPinBlock(
        HexLengthBetween16And32.unwrap(encryptedPinBlock): java.lang.String
      )
      .pinVerificationKeyIndex(
        IntegerRangeBetween0And9.unwrap(pinVerificationKeyIndex): Integer
      )
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptographydata.model.VisaPinVerificationValue.ReadOnly =
    zio.aws.paymentcryptographydata.model.VisaPinVerificationValue
      .wrap(buildAwsValue())
}
object VisaPinVerificationValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.VisaPinVerificationValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.paymentcryptographydata.model.VisaPinVerificationValue =
      zio.aws.paymentcryptographydata.model
        .VisaPinVerificationValue(encryptedPinBlock, pinVerificationKeyIndex)
    def encryptedPinBlock: HexLengthBetween16And32
    def pinVerificationKeyIndex: IntegerRangeBetween0And9
    def getEncryptedPinBlock: ZIO[Any, Nothing, HexLengthBetween16And32] =
      ZIO.succeed(encryptedPinBlock)
    def getPinVerificationKeyIndex
        : ZIO[Any, Nothing, IntegerRangeBetween0And9] =
      ZIO.succeed(pinVerificationKeyIndex)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.VisaPinVerificationValue
  ) extends zio.aws.paymentcryptographydata.model.VisaPinVerificationValue.ReadOnly {
    override val encryptedPinBlock: HexLengthBetween16And32 =
      zio.aws.paymentcryptographydata.model.primitives
        .HexLengthBetween16And32(impl.encryptedPinBlock())
    override val pinVerificationKeyIndex: IntegerRangeBetween0And9 =
      zio.aws.paymentcryptographydata.model.primitives
        .IntegerRangeBetween0And9(impl.pinVerificationKeyIndex())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.VisaPinVerificationValue
  ): zio.aws.paymentcryptographydata.model.VisaPinVerificationValue.ReadOnly =
    new Wrapper(impl)
}
