package zio.aws.paymentcryptographydata.model
import zio.aws.paymentcryptographydata.model.primitives.NumberLengthBetween12And19
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TranslationPinDataIsoFormat034(
    primaryAccountNumber: NumberLengthBetween12And19
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.TranslationPinDataIsoFormat034 = {
    import TranslationPinDataIsoFormat034.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.TranslationPinDataIsoFormat034
      .builder()
      .primaryAccountNumber(
        NumberLengthBetween12And19.unwrap(
          primaryAccountNumber
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptographydata.model.TranslationPinDataIsoFormat034.ReadOnly =
    zio.aws.paymentcryptographydata.model.TranslationPinDataIsoFormat034
      .wrap(buildAwsValue())
}
object TranslationPinDataIsoFormat034 {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.TranslationPinDataIsoFormat034
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.paymentcryptographydata.model.TranslationPinDataIsoFormat034 =
      zio.aws.paymentcryptographydata.model
        .TranslationPinDataIsoFormat034(primaryAccountNumber)
    def primaryAccountNumber: NumberLengthBetween12And19
    def getPrimaryAccountNumber: ZIO[Any, Nothing, NumberLengthBetween12And19] =
      ZIO.succeed(primaryAccountNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.TranslationPinDataIsoFormat034
  ) extends zio.aws.paymentcryptographydata.model.TranslationPinDataIsoFormat034.ReadOnly {
    override val primaryAccountNumber: NumberLengthBetween12And19 =
      zio.aws.paymentcryptographydata.model.primitives
        .NumberLengthBetween12And19(impl.primaryAccountNumber())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.TranslationPinDataIsoFormat034
  ): zio.aws.paymentcryptographydata.model.TranslationPinDataIsoFormat034.ReadOnly =
    new Wrapper(impl)
}
