package zio.aws.paymentcryptographydata.model
import zio.aws.paymentcryptographydata.model.primitives.{
  KeyCheckValue,
  KeyArn,
  HexEvenLengthBetween16And4096
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ReEncryptDataResponse(
    cipherText: HexEvenLengthBetween16And4096,
    keyArn: KeyArn,
    keyCheckValue: KeyCheckValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.ReEncryptDataResponse = {
    import ReEncryptDataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.ReEncryptDataResponse
      .builder()
      .cipherText(
        HexEvenLengthBetween16And4096.unwrap(cipherText): java.lang.String
      )
      .keyArn(KeyArn.unwrap(keyArn): java.lang.String)
      .keyCheckValue(KeyCheckValue.unwrap(keyCheckValue): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptographydata.model.ReEncryptDataResponse.ReadOnly =
    zio.aws.paymentcryptographydata.model.ReEncryptDataResponse
      .wrap(buildAwsValue())
}
object ReEncryptDataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.ReEncryptDataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.paymentcryptographydata.model.ReEncryptDataResponse =
      zio.aws.paymentcryptographydata.model
        .ReEncryptDataResponse(cipherText, keyArn, keyCheckValue)
    def cipherText: HexEvenLengthBetween16And4096
    def keyArn: KeyArn
    def keyCheckValue: KeyCheckValue
    def getCipherText: ZIO[Any, Nothing, HexEvenLengthBetween16And4096] =
      ZIO.succeed(cipherText)
    def getKeyArn: ZIO[Any, Nothing, KeyArn] = ZIO.succeed(keyArn)
    def getKeyCheckValue: ZIO[Any, Nothing, KeyCheckValue] =
      ZIO.succeed(keyCheckValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.ReEncryptDataResponse
  ) extends zio.aws.paymentcryptographydata.model.ReEncryptDataResponse.ReadOnly {
    override val cipherText: HexEvenLengthBetween16And4096 =
      zio.aws.paymentcryptographydata.model.primitives
        .HexEvenLengthBetween16And4096(impl.cipherText())
    override val keyArn: KeyArn =
      zio.aws.paymentcryptographydata.model.primitives.KeyArn(impl.keyArn())
    override val keyCheckValue: KeyCheckValue =
      zio.aws.paymentcryptographydata.model.primitives
        .KeyCheckValue(impl.keyCheckValue())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.ReEncryptDataResponse
  ): zio.aws.paymentcryptographydata.model.ReEncryptDataResponse.ReadOnly =
    new Wrapper(impl)
}
