package zio.aws.paymentcryptographydata.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.paymentcryptographydata.model.primitives.{
  NumberLengthBetween12And19,
  IntegerRangeBetween4And12,
  KeyArnOrKeyAliasType
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GeneratePinDataRequest(
    encryptionKeyIdentifier: KeyArnOrKeyAliasType,
    generationAttributes: zio.aws.paymentcryptographydata.model.PinGenerationAttributes,
    generationKeyIdentifier: KeyArnOrKeyAliasType,
    pinBlockFormat: zio.aws.paymentcryptographydata.model.PinBlockFormatForPinData,
    pinDataLength: Optional[IntegerRangeBetween4And12] = Optional.Absent,
    primaryAccountNumber: NumberLengthBetween12And19
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.GeneratePinDataRequest = {
    import GeneratePinDataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.GeneratePinDataRequest
      .builder()
      .encryptionKeyIdentifier(
        KeyArnOrKeyAliasType.unwrap(encryptionKeyIdentifier): java.lang.String
      )
      .generationAttributes(generationAttributes.buildAwsValue())
      .generationKeyIdentifier(
        KeyArnOrKeyAliasType.unwrap(generationKeyIdentifier): java.lang.String
      )
      .pinBlockFormat(pinBlockFormat.unwrap)
      .optionallyWith(
        pinDataLength.map(value =>
          IntegerRangeBetween4And12.unwrap(value): Integer
        )
      )(_.pinDataLength)
      .primaryAccountNumber(
        NumberLengthBetween12And19.unwrap(
          primaryAccountNumber
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptographydata.model.GeneratePinDataRequest.ReadOnly =
    zio.aws.paymentcryptographydata.model.GeneratePinDataRequest
      .wrap(buildAwsValue())
}
object GeneratePinDataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.GeneratePinDataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.paymentcryptographydata.model.GeneratePinDataRequest =
      zio.aws.paymentcryptographydata.model.GeneratePinDataRequest(
        encryptionKeyIdentifier,
        generationAttributes.asEditable,
        generationKeyIdentifier,
        pinBlockFormat,
        pinDataLength.map(value => value),
        primaryAccountNumber
      )
    def encryptionKeyIdentifier: KeyArnOrKeyAliasType
    def generationAttributes
        : zio.aws.paymentcryptographydata.model.PinGenerationAttributes.ReadOnly
    def generationKeyIdentifier: KeyArnOrKeyAliasType
    def pinBlockFormat
        : zio.aws.paymentcryptographydata.model.PinBlockFormatForPinData
    def pinDataLength: Optional[IntegerRangeBetween4And12]
    def primaryAccountNumber: NumberLengthBetween12And19
    def getEncryptionKeyIdentifier: ZIO[Any, Nothing, KeyArnOrKeyAliasType] =
      ZIO.succeed(encryptionKeyIdentifier)
    def getGenerationAttributes: ZIO[
      Any,
      Nothing,
      zio.aws.paymentcryptographydata.model.PinGenerationAttributes.ReadOnly
    ] = ZIO.succeed(generationAttributes)
    def getGenerationKeyIdentifier: ZIO[Any, Nothing, KeyArnOrKeyAliasType] =
      ZIO.succeed(generationKeyIdentifier)
    def getPinBlockFormat: ZIO[
      Any,
      Nothing,
      zio.aws.paymentcryptographydata.model.PinBlockFormatForPinData
    ] = ZIO.succeed(pinBlockFormat)
    def getPinDataLength: ZIO[Any, AwsError, IntegerRangeBetween4And12] =
      AwsError.unwrapOptionField("pinDataLength", pinDataLength)
    def getPrimaryAccountNumber: ZIO[Any, Nothing, NumberLengthBetween12And19] =
      ZIO.succeed(primaryAccountNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.GeneratePinDataRequest
  ) extends zio.aws.paymentcryptographydata.model.GeneratePinDataRequest.ReadOnly {
    override val encryptionKeyIdentifier: KeyArnOrKeyAliasType =
      zio.aws.paymentcryptographydata.model.primitives
        .KeyArnOrKeyAliasType(impl.encryptionKeyIdentifier())
    override val generationAttributes
        : zio.aws.paymentcryptographydata.model.PinGenerationAttributes.ReadOnly =
      zio.aws.paymentcryptographydata.model.PinGenerationAttributes
        .wrap(impl.generationAttributes())
    override val generationKeyIdentifier: KeyArnOrKeyAliasType =
      zio.aws.paymentcryptographydata.model.primitives
        .KeyArnOrKeyAliasType(impl.generationKeyIdentifier())
    override val pinBlockFormat
        : zio.aws.paymentcryptographydata.model.PinBlockFormatForPinData =
      zio.aws.paymentcryptographydata.model.PinBlockFormatForPinData
        .wrap(impl.pinBlockFormat())
    override val pinDataLength: Optional[IntegerRangeBetween4And12] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pinDataLength())
        .map(value =>
          zio.aws.paymentcryptographydata.model.primitives
            .IntegerRangeBetween4And12(value)
        )
    override val primaryAccountNumber: NumberLengthBetween12And19 =
      zio.aws.paymentcryptographydata.model.primitives
        .NumberLengthBetween12And19(impl.primaryAccountNumber())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.GeneratePinDataRequest
  ): zio.aws.paymentcryptographydata.model.GeneratePinDataRequest.ReadOnly =
    new Wrapper(impl)
}
