package zio.aws.paymentcryptographydata.model
import zio.aws.paymentcryptographydata.model.primitives.{
  KeyArnOrKeyAliasType,
  HexEvenLengthBetween16And4096
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DecryptDataRequest(
    cipherText: HexEvenLengthBetween16And4096,
    decryptionAttributes: zio.aws.paymentcryptographydata.model.EncryptionDecryptionAttributes,
    keyIdentifier: KeyArnOrKeyAliasType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.DecryptDataRequest = {
    import DecryptDataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.DecryptDataRequest
      .builder()
      .cipherText(
        HexEvenLengthBetween16And4096.unwrap(cipherText): java.lang.String
      )
      .decryptionAttributes(decryptionAttributes.buildAwsValue())
      .keyIdentifier(
        KeyArnOrKeyAliasType.unwrap(keyIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptographydata.model.DecryptDataRequest.ReadOnly =
    zio.aws.paymentcryptographydata.model.DecryptDataRequest
      .wrap(buildAwsValue())
}
object DecryptDataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.DecryptDataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptographydata.model.DecryptDataRequest =
      zio.aws.paymentcryptographydata.model.DecryptDataRequest(
        cipherText,
        decryptionAttributes.asEditable,
        keyIdentifier
      )
    def cipherText: HexEvenLengthBetween16And4096
    def decryptionAttributes
        : zio.aws.paymentcryptographydata.model.EncryptionDecryptionAttributes.ReadOnly
    def keyIdentifier: KeyArnOrKeyAliasType
    def getCipherText: ZIO[Any, Nothing, HexEvenLengthBetween16And4096] =
      ZIO.succeed(cipherText)
    def getDecryptionAttributes: ZIO[
      Any,
      Nothing,
      zio.aws.paymentcryptographydata.model.EncryptionDecryptionAttributes.ReadOnly
    ] = ZIO.succeed(decryptionAttributes)
    def getKeyIdentifier: ZIO[Any, Nothing, KeyArnOrKeyAliasType] =
      ZIO.succeed(keyIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.DecryptDataRequest
  ) extends zio.aws.paymentcryptographydata.model.DecryptDataRequest.ReadOnly {
    override val cipherText: HexEvenLengthBetween16And4096 =
      zio.aws.paymentcryptographydata.model.primitives
        .HexEvenLengthBetween16And4096(impl.cipherText())
    override val decryptionAttributes
        : zio.aws.paymentcryptographydata.model.EncryptionDecryptionAttributes.ReadOnly =
      zio.aws.paymentcryptographydata.model.EncryptionDecryptionAttributes
        .wrap(impl.decryptionAttributes())
    override val keyIdentifier: KeyArnOrKeyAliasType =
      zio.aws.paymentcryptographydata.model.primitives
        .KeyArnOrKeyAliasType(impl.keyIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.DecryptDataRequest
  ): zio.aws.paymentcryptographydata.model.DecryptDataRequest.ReadOnly =
    new Wrapper(impl)
}
