package zio.aws.paymentcryptographydata.model
import zio.aws.paymentcryptographydata.model.primitives.HexLengthEquals4
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CryptogramVerificationArpcMethod1(
    authResponseCode: HexLengthEquals4
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.CryptogramVerificationArpcMethod1 = {
    import CryptogramVerificationArpcMethod1.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.CryptogramVerificationArpcMethod1
      .builder()
      .authResponseCode(
        HexLengthEquals4.unwrap(authResponseCode): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptographydata.model.CryptogramVerificationArpcMethod1.ReadOnly =
    zio.aws.paymentcryptographydata.model.CryptogramVerificationArpcMethod1
      .wrap(buildAwsValue())
}
object CryptogramVerificationArpcMethod1 {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.CryptogramVerificationArpcMethod1
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.paymentcryptographydata.model.CryptogramVerificationArpcMethod1 =
      zio.aws.paymentcryptographydata.model
        .CryptogramVerificationArpcMethod1(authResponseCode)
    def authResponseCode: HexLengthEquals4
    def getAuthResponseCode: ZIO[Any, Nothing, HexLengthEquals4] =
      ZIO.succeed(authResponseCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.CryptogramVerificationArpcMethod1
  ) extends zio.aws.paymentcryptographydata.model.CryptogramVerificationArpcMethod1.ReadOnly {
    override val authResponseCode: HexLengthEquals4 =
      zio.aws.paymentcryptographydata.model.primitives
        .HexLengthEquals4(impl.authResponseCode())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.CryptogramVerificationArpcMethod1
  ): zio.aws.paymentcryptographydata.model.CryptogramVerificationArpcMethod1.ReadOnly =
    new Wrapper(impl)
}
