package zio.aws.paymentcryptographydata.model
import zio.aws.paymentcryptographydata.model.primitives.HexLengthBetween10And24
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DukptDerivationAttributes(
    dukptKeyDerivationType: Optional[
      zio.aws.paymentcryptographydata.model.DukptDerivationType
    ] = Optional.Absent,
    dukptKeyVariant: Optional[
      zio.aws.paymentcryptographydata.model.DukptKeyVariant
    ] = Optional.Absent,
    keySerialNumber: HexLengthBetween10And24
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.DukptDerivationAttributes = {
    import DukptDerivationAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.DukptDerivationAttributes
      .builder()
      .optionallyWith(dukptKeyDerivationType.map(value => value.unwrap))(
        _.dukptKeyDerivationType
      )
      .optionallyWith(dukptKeyVariant.map(value => value.unwrap))(
        _.dukptKeyVariant
      )
      .keySerialNumber(
        HexLengthBetween10And24.unwrap(keySerialNumber): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptographydata.model.DukptDerivationAttributes.ReadOnly =
    zio.aws.paymentcryptographydata.model.DukptDerivationAttributes
      .wrap(buildAwsValue())
}
object DukptDerivationAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.DukptDerivationAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.paymentcryptographydata.model.DukptDerivationAttributes =
      zio.aws.paymentcryptographydata.model.DukptDerivationAttributes(
        dukptKeyDerivationType.map(value => value),
        dukptKeyVariant.map(value => value),
        keySerialNumber
      )
    def dukptKeyDerivationType
        : Optional[zio.aws.paymentcryptographydata.model.DukptDerivationType]
    def dukptKeyVariant
        : Optional[zio.aws.paymentcryptographydata.model.DukptKeyVariant]
    def keySerialNumber: HexLengthBetween10And24
    def getDukptKeyDerivationType: ZIO[
      Any,
      AwsError,
      zio.aws.paymentcryptographydata.model.DukptDerivationType
    ] = AwsError.unwrapOptionField(
      "dukptKeyDerivationType",
      dukptKeyDerivationType
    )
    def getDukptKeyVariant: ZIO[
      Any,
      AwsError,
      zio.aws.paymentcryptographydata.model.DukptKeyVariant
    ] = AwsError.unwrapOptionField("dukptKeyVariant", dukptKeyVariant)
    def getKeySerialNumber: ZIO[Any, Nothing, HexLengthBetween10And24] =
      ZIO.succeed(keySerialNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.DukptDerivationAttributes
  ) extends zio.aws.paymentcryptographydata.model.DukptDerivationAttributes.ReadOnly {
    override val dukptKeyDerivationType
        : Optional[zio.aws.paymentcryptographydata.model.DukptDerivationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dukptKeyDerivationType())
        .map(value =>
          zio.aws.paymentcryptographydata.model.DukptDerivationType.wrap(value)
        )
    override val dukptKeyVariant
        : Optional[zio.aws.paymentcryptographydata.model.DukptKeyVariant] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dukptKeyVariant())
        .map(value =>
          zio.aws.paymentcryptographydata.model.DukptKeyVariant.wrap(value)
        )
    override val keySerialNumber: HexLengthBetween10And24 =
      zio.aws.paymentcryptographydata.model.primitives
        .HexLengthBetween10And24(impl.keySerialNumber())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.DukptDerivationAttributes
  ): zio.aws.paymentcryptographydata.model.DukptDerivationAttributes.ReadOnly =
    new Wrapper(impl)
}
