package zio.aws.paymentcryptographydata.model
import zio.aws.paymentcryptographydata.model.primitives.{
  HexLengthBetween2And1024,
  KeyArnOrKeyAliasType,
  HexLengthEquals16
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VerifyAuthRequestCryptogramRequest(
    authRequestCryptogram: HexLengthEquals16,
    authResponseAttributes: Optional[
      zio.aws.paymentcryptographydata.model.CryptogramAuthResponse
    ] = Optional.Absent,
    keyIdentifier: KeyArnOrKeyAliasType,
    majorKeyDerivationMode: zio.aws.paymentcryptographydata.model.MajorKeyDerivationMode,
    sessionKeyDerivationAttributes: zio.aws.paymentcryptographydata.model.SessionKeyDerivation,
    transactionData: HexLengthBetween2And1024
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.VerifyAuthRequestCryptogramRequest = {
    import VerifyAuthRequestCryptogramRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.VerifyAuthRequestCryptogramRequest
      .builder()
      .authRequestCryptogram(
        HexLengthEquals16.unwrap(authRequestCryptogram): java.lang.String
      )
      .optionallyWith(
        authResponseAttributes.map(value => value.buildAwsValue())
      )(_.authResponseAttributes)
      .keyIdentifier(
        KeyArnOrKeyAliasType.unwrap(keyIdentifier): java.lang.String
      )
      .majorKeyDerivationMode(majorKeyDerivationMode.unwrap)
      .sessionKeyDerivationAttributes(
        sessionKeyDerivationAttributes.buildAwsValue()
      )
      .transactionData(
        HexLengthBetween2And1024.unwrap(transactionData): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptographydata.model.VerifyAuthRequestCryptogramRequest.ReadOnly =
    zio.aws.paymentcryptographydata.model.VerifyAuthRequestCryptogramRequest
      .wrap(buildAwsValue())
}
object VerifyAuthRequestCryptogramRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.VerifyAuthRequestCryptogramRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.paymentcryptographydata.model.VerifyAuthRequestCryptogramRequest =
      zio.aws.paymentcryptographydata.model.VerifyAuthRequestCryptogramRequest(
        authRequestCryptogram,
        authResponseAttributes.map(value => value.asEditable),
        keyIdentifier,
        majorKeyDerivationMode,
        sessionKeyDerivationAttributes.asEditable,
        transactionData
      )
    def authRequestCryptogram: HexLengthEquals16
    def authResponseAttributes: Optional[
      zio.aws.paymentcryptographydata.model.CryptogramAuthResponse.ReadOnly
    ]
    def keyIdentifier: KeyArnOrKeyAliasType
    def majorKeyDerivationMode
        : zio.aws.paymentcryptographydata.model.MajorKeyDerivationMode
    def sessionKeyDerivationAttributes
        : zio.aws.paymentcryptographydata.model.SessionKeyDerivation.ReadOnly
    def transactionData: HexLengthBetween2And1024
    def getAuthRequestCryptogram: ZIO[Any, Nothing, HexLengthEquals16] =
      ZIO.succeed(authRequestCryptogram)
    def getAuthResponseAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.paymentcryptographydata.model.CryptogramAuthResponse.ReadOnly
    ] = AwsError.unwrapOptionField(
      "authResponseAttributes",
      authResponseAttributes
    )
    def getKeyIdentifier: ZIO[Any, Nothing, KeyArnOrKeyAliasType] =
      ZIO.succeed(keyIdentifier)
    def getMajorKeyDerivationMode: ZIO[
      Any,
      Nothing,
      zio.aws.paymentcryptographydata.model.MajorKeyDerivationMode
    ] = ZIO.succeed(majorKeyDerivationMode)
    def getSessionKeyDerivationAttributes: ZIO[
      Any,
      Nothing,
      zio.aws.paymentcryptographydata.model.SessionKeyDerivation.ReadOnly
    ] = ZIO.succeed(sessionKeyDerivationAttributes)
    def getTransactionData: ZIO[Any, Nothing, HexLengthBetween2And1024] =
      ZIO.succeed(transactionData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.VerifyAuthRequestCryptogramRequest
  ) extends zio.aws.paymentcryptographydata.model.VerifyAuthRequestCryptogramRequest.ReadOnly {
    override val authRequestCryptogram: HexLengthEquals16 =
      zio.aws.paymentcryptographydata.model.primitives
        .HexLengthEquals16(impl.authRequestCryptogram())
    override val authResponseAttributes: Optional[
      zio.aws.paymentcryptographydata.model.CryptogramAuthResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.authResponseAttributes())
      .map(value =>
        zio.aws.paymentcryptographydata.model.CryptogramAuthResponse.wrap(value)
      )
    override val keyIdentifier: KeyArnOrKeyAliasType =
      zio.aws.paymentcryptographydata.model.primitives
        .KeyArnOrKeyAliasType(impl.keyIdentifier())
    override val majorKeyDerivationMode
        : zio.aws.paymentcryptographydata.model.MajorKeyDerivationMode =
      zio.aws.paymentcryptographydata.model.MajorKeyDerivationMode
        .wrap(impl.majorKeyDerivationMode())
    override val sessionKeyDerivationAttributes
        : zio.aws.paymentcryptographydata.model.SessionKeyDerivation.ReadOnly =
      zio.aws.paymentcryptographydata.model.SessionKeyDerivation
        .wrap(impl.sessionKeyDerivationAttributes())
    override val transactionData: HexLengthBetween2And1024 =
      zio.aws.paymentcryptographydata.model.primitives
        .HexLengthBetween2And1024(impl.transactionData())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.VerifyAuthRequestCryptogramRequest
  ): zio.aws.paymentcryptographydata.model.VerifyAuthRequestCryptogramRequest.ReadOnly =
    new Wrapper(impl)
}
