package zio.aws.paymentcryptographydata.model
import zio.aws.paymentcryptographydata.model.primitives.{
  NumberLengthBetween3And5,
  KeyCheckValue,
  KeyArn
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GenerateCardValidationDataResponse(
    keyArn: KeyArn,
    keyCheckValue: KeyCheckValue,
    validationData: NumberLengthBetween3And5
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.GenerateCardValidationDataResponse = {
    import GenerateCardValidationDataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.GenerateCardValidationDataResponse
      .builder()
      .keyArn(KeyArn.unwrap(keyArn): java.lang.String)
      .keyCheckValue(KeyCheckValue.unwrap(keyCheckValue): java.lang.String)
      .validationData(
        NumberLengthBetween3And5.unwrap(validationData): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptographydata.model.GenerateCardValidationDataResponse.ReadOnly =
    zio.aws.paymentcryptographydata.model.GenerateCardValidationDataResponse
      .wrap(buildAwsValue())
}
object GenerateCardValidationDataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.GenerateCardValidationDataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.paymentcryptographydata.model.GenerateCardValidationDataResponse =
      zio.aws.paymentcryptographydata.model.GenerateCardValidationDataResponse(
        keyArn,
        keyCheckValue,
        validationData
      )
    def keyArn: KeyArn
    def keyCheckValue: KeyCheckValue
    def validationData: NumberLengthBetween3And5
    def getKeyArn: ZIO[Any, Nothing, KeyArn] = ZIO.succeed(keyArn)
    def getKeyCheckValue: ZIO[Any, Nothing, KeyCheckValue] =
      ZIO.succeed(keyCheckValue)
    def getValidationData: ZIO[Any, Nothing, NumberLengthBetween3And5] =
      ZIO.succeed(validationData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.GenerateCardValidationDataResponse
  ) extends zio.aws.paymentcryptographydata.model.GenerateCardValidationDataResponse.ReadOnly {
    override val keyArn: KeyArn =
      zio.aws.paymentcryptographydata.model.primitives.KeyArn(impl.keyArn())
    override val keyCheckValue: KeyCheckValue =
      zio.aws.paymentcryptographydata.model.primitives
        .KeyCheckValue(impl.keyCheckValue())
    override val validationData: NumberLengthBetween3And5 =
      zio.aws.paymentcryptographydata.model.primitives
        .NumberLengthBetween3And5(impl.validationData())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.GenerateCardValidationDataResponse
  ): zio.aws.paymentcryptographydata.model.GenerateCardValidationDataResponse.ReadOnly =
    new Wrapper(impl)
}
