package zio.aws.paymentcryptographydata.model
import zio.aws.paymentcryptographydata.model.primitives.{
  NumberLengthBetween3And5,
  NumberLengthBetween12And19,
  KeyArnOrKeyAliasType
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class VerifyCardValidationDataRequest(
    keyIdentifier: KeyArnOrKeyAliasType,
    primaryAccountNumber: NumberLengthBetween12And19,
    validationData: NumberLengthBetween3And5,
    verificationAttributes: zio.aws.paymentcryptographydata.model.CardVerificationAttributes
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.VerifyCardValidationDataRequest = {
    import VerifyCardValidationDataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.VerifyCardValidationDataRequest
      .builder()
      .keyIdentifier(
        KeyArnOrKeyAliasType.unwrap(keyIdentifier): java.lang.String
      )
      .primaryAccountNumber(
        NumberLengthBetween12And19.unwrap(
          primaryAccountNumber
        ): java.lang.String
      )
      .validationData(
        NumberLengthBetween3And5.unwrap(validationData): java.lang.String
      )
      .verificationAttributes(verificationAttributes.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptographydata.model.VerifyCardValidationDataRequest.ReadOnly =
    zio.aws.paymentcryptographydata.model.VerifyCardValidationDataRequest
      .wrap(buildAwsValue())
}
object VerifyCardValidationDataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.VerifyCardValidationDataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.paymentcryptographydata.model.VerifyCardValidationDataRequest =
      zio.aws.paymentcryptographydata.model.VerifyCardValidationDataRequest(
        keyIdentifier,
        primaryAccountNumber,
        validationData,
        verificationAttributes.asEditable
      )
    def keyIdentifier: KeyArnOrKeyAliasType
    def primaryAccountNumber: NumberLengthBetween12And19
    def validationData: NumberLengthBetween3And5
    def verificationAttributes
        : zio.aws.paymentcryptographydata.model.CardVerificationAttributes.ReadOnly
    def getKeyIdentifier: ZIO[Any, Nothing, KeyArnOrKeyAliasType] =
      ZIO.succeed(keyIdentifier)
    def getPrimaryAccountNumber: ZIO[Any, Nothing, NumberLengthBetween12And19] =
      ZIO.succeed(primaryAccountNumber)
    def getValidationData: ZIO[Any, Nothing, NumberLengthBetween3And5] =
      ZIO.succeed(validationData)
    def getVerificationAttributes: ZIO[
      Any,
      Nothing,
      zio.aws.paymentcryptographydata.model.CardVerificationAttributes.ReadOnly
    ] = ZIO.succeed(verificationAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.VerifyCardValidationDataRequest
  ) extends zio.aws.paymentcryptographydata.model.VerifyCardValidationDataRequest.ReadOnly {
    override val keyIdentifier: KeyArnOrKeyAliasType =
      zio.aws.paymentcryptographydata.model.primitives
        .KeyArnOrKeyAliasType(impl.keyIdentifier())
    override val primaryAccountNumber: NumberLengthBetween12And19 =
      zio.aws.paymentcryptographydata.model.primitives
        .NumberLengthBetween12And19(impl.primaryAccountNumber())
    override val validationData: NumberLengthBetween3And5 =
      zio.aws.paymentcryptographydata.model.primitives
        .NumberLengthBetween3And5(impl.validationData())
    override val verificationAttributes
        : zio.aws.paymentcryptographydata.model.CardVerificationAttributes.ReadOnly =
      zio.aws.paymentcryptographydata.model.CardVerificationAttributes
        .wrap(impl.verificationAttributes())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.VerifyCardValidationDataRequest
  ): zio.aws.paymentcryptographydata.model.VerifyCardValidationDataRequest.ReadOnly =
    new Wrapper(impl)
}
