package zio.aws.paymentcryptographydata.model
import zio.aws.paymentcryptographydata.model.primitives.NumberLengthEquals4
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CardVerificationValue2(cardExpiryDate: NumberLengthEquals4) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.CardVerificationValue2 = {
    import CardVerificationValue2.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.CardVerificationValue2
      .builder()
      .cardExpiryDate(
        NumberLengthEquals4.unwrap(cardExpiryDate): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptographydata.model.CardVerificationValue2.ReadOnly =
    zio.aws.paymentcryptographydata.model.CardVerificationValue2
      .wrap(buildAwsValue())
}
object CardVerificationValue2 {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.CardVerificationValue2
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.paymentcryptographydata.model.CardVerificationValue2 =
      zio.aws.paymentcryptographydata.model
        .CardVerificationValue2(cardExpiryDate)
    def cardExpiryDate: NumberLengthEquals4
    def getCardExpiryDate: ZIO[Any, Nothing, NumberLengthEquals4] =
      ZIO.succeed(cardExpiryDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.CardVerificationValue2
  ) extends zio.aws.paymentcryptographydata.model.CardVerificationValue2.ReadOnly {
    override val cardExpiryDate: NumberLengthEquals4 =
      zio.aws.paymentcryptographydata.model.primitives
        .NumberLengthEquals4(impl.cardExpiryDate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.CardVerificationValue2
  ): zio.aws.paymentcryptographydata.model.CardVerificationValue2.ReadOnly =
    new Wrapper(impl)
}
