package zio.aws.paymentcryptographydata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AsymmetricEncryptionAttributes(
    paddingType: Optional[zio.aws.paymentcryptographydata.model.PaddingType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.AsymmetricEncryptionAttributes = {
    import AsymmetricEncryptionAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.AsymmetricEncryptionAttributes
      .builder()
      .optionallyWith(paddingType.map(value => value.unwrap))(_.paddingType)
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptographydata.model.AsymmetricEncryptionAttributes.ReadOnly =
    zio.aws.paymentcryptographydata.model.AsymmetricEncryptionAttributes
      .wrap(buildAwsValue())
}
object AsymmetricEncryptionAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.AsymmetricEncryptionAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.paymentcryptographydata.model.AsymmetricEncryptionAttributes =
      zio.aws.paymentcryptographydata.model
        .AsymmetricEncryptionAttributes(paddingType.map(value => value))
    def paddingType: Optional[zio.aws.paymentcryptographydata.model.PaddingType]
    def getPaddingType: ZIO[
      Any,
      AwsError,
      zio.aws.paymentcryptographydata.model.PaddingType
    ] = AwsError.unwrapOptionField("paddingType", paddingType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.AsymmetricEncryptionAttributes
  ) extends zio.aws.paymentcryptographydata.model.AsymmetricEncryptionAttributes.ReadOnly {
    override val paddingType
        : Optional[zio.aws.paymentcryptographydata.model.PaddingType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.paddingType())
        .map(value =>
          zio.aws.paymentcryptographydata.model.PaddingType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.AsymmetricEncryptionAttributes
  ): zio.aws.paymentcryptographydata.model.AsymmetricEncryptionAttributes.ReadOnly =
    new Wrapper(impl)
}
