package zio.aws.paymentcryptographydata.model
import zio.aws.paymentcryptographydata.model.primitives.{KeyCheckValue, KeyArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class VerifyMacResponse(
    keyArn: KeyArn,
    keyCheckValue: KeyCheckValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.VerifyMacResponse = {
    import VerifyMacResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.VerifyMacResponse
      .builder()
      .keyArn(KeyArn.unwrap(keyArn): java.lang.String)
      .keyCheckValue(KeyCheckValue.unwrap(keyCheckValue): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptographydata.model.VerifyMacResponse.ReadOnly =
    zio.aws.paymentcryptographydata.model.VerifyMacResponse
      .wrap(buildAwsValue())
}
object VerifyMacResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.VerifyMacResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptographydata.model.VerifyMacResponse =
      zio.aws.paymentcryptographydata.model
        .VerifyMacResponse(keyArn, keyCheckValue)
    def keyArn: KeyArn
    def keyCheckValue: KeyCheckValue
    def getKeyArn: ZIO[Any, Nothing, KeyArn] = ZIO.succeed(keyArn)
    def getKeyCheckValue: ZIO[Any, Nothing, KeyCheckValue] =
      ZIO.succeed(keyCheckValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.VerifyMacResponse
  ) extends zio.aws.paymentcryptographydata.model.VerifyMacResponse.ReadOnly {
    override val keyArn: KeyArn =
      zio.aws.paymentcryptographydata.model.primitives.KeyArn(impl.keyArn())
    override val keyCheckValue: KeyCheckValue =
      zio.aws.paymentcryptographydata.model.primitives
        .KeyCheckValue(impl.keyCheckValue())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.VerifyMacResponse
  ): zio.aws.paymentcryptographydata.model.VerifyMacResponse.ReadOnly =
    new Wrapper(impl)
}
