package zio.aws.paymentcryptographydata.model
import zio.aws.paymentcryptographydata.model.primitives.{KeyCheckValue, KeyArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class VerifyCardValidationDataResponse(
    keyArn: KeyArn,
    keyCheckValue: KeyCheckValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.VerifyCardValidationDataResponse = {
    import VerifyCardValidationDataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.VerifyCardValidationDataResponse
      .builder()
      .keyArn(KeyArn.unwrap(keyArn): java.lang.String)
      .keyCheckValue(KeyCheckValue.unwrap(keyCheckValue): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptographydata.model.VerifyCardValidationDataResponse.ReadOnly =
    zio.aws.paymentcryptographydata.model.VerifyCardValidationDataResponse
      .wrap(buildAwsValue())
}
object VerifyCardValidationDataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.VerifyCardValidationDataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.paymentcryptographydata.model.VerifyCardValidationDataResponse =
      zio.aws.paymentcryptographydata.model
        .VerifyCardValidationDataResponse(keyArn, keyCheckValue)
    def keyArn: KeyArn
    def keyCheckValue: KeyCheckValue
    def getKeyArn: ZIO[Any, Nothing, KeyArn] = ZIO.succeed(keyArn)
    def getKeyCheckValue: ZIO[Any, Nothing, KeyCheckValue] =
      ZIO.succeed(keyCheckValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.VerifyCardValidationDataResponse
  ) extends zio.aws.paymentcryptographydata.model.VerifyCardValidationDataResponse.ReadOnly {
    override val keyArn: KeyArn =
      zio.aws.paymentcryptographydata.model.primitives.KeyArn(impl.keyArn())
    override val keyCheckValue: KeyCheckValue =
      zio.aws.paymentcryptographydata.model.primitives
        .KeyCheckValue(impl.keyCheckValue())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.VerifyCardValidationDataResponse
  ): zio.aws.paymentcryptographydata.model.VerifyCardValidationDataResponse.ReadOnly =
    new Wrapper(impl)
}
