package zio.aws.paymentcryptographydata.model
import zio.aws.paymentcryptographydata.model.primitives.{
  NumberLengthBetween12And19,
  HexLengthEquals2
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SessionKeyAmex(
    panSequenceNumber: HexLengthEquals2,
    primaryAccountNumber: NumberLengthBetween12And19
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyAmex = {
    import SessionKeyAmex.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyAmex
      .builder()
      .panSequenceNumber(
        HexLengthEquals2.unwrap(panSequenceNumber): java.lang.String
      )
      .primaryAccountNumber(
        NumberLengthBetween12And19.unwrap(
          primaryAccountNumber
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptographydata.model.SessionKeyAmex.ReadOnly =
    zio.aws.paymentcryptographydata.model.SessionKeyAmex.wrap(buildAwsValue())
}
object SessionKeyAmex {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyAmex
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptographydata.model.SessionKeyAmex =
      zio.aws.paymentcryptographydata.model
        .SessionKeyAmex(panSequenceNumber, primaryAccountNumber)
    def panSequenceNumber: HexLengthEquals2
    def primaryAccountNumber: NumberLengthBetween12And19
    def getPanSequenceNumber: ZIO[Any, Nothing, HexLengthEquals2] =
      ZIO.succeed(panSequenceNumber)
    def getPrimaryAccountNumber: ZIO[Any, Nothing, NumberLengthBetween12And19] =
      ZIO.succeed(primaryAccountNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyAmex
  ) extends zio.aws.paymentcryptographydata.model.SessionKeyAmex.ReadOnly {
    override val panSequenceNumber: HexLengthEquals2 =
      zio.aws.paymentcryptographydata.model.primitives
        .HexLengthEquals2(impl.panSequenceNumber())
    override val primaryAccountNumber: NumberLengthBetween12And19 =
      zio.aws.paymentcryptographydata.model.primitives
        .NumberLengthBetween12And19(impl.primaryAccountNumber())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyAmex
  ): zio.aws.paymentcryptographydata.model.SessionKeyAmex.ReadOnly =
    new Wrapper(impl)
}
