package zio.aws.paymentcryptographydata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MacAttributes(
    algorithm: Optional[zio.aws.paymentcryptographydata.model.MacAlgorithm] =
      Optional.Absent,
    dukptCmac: Optional[
      zio.aws.paymentcryptographydata.model.MacAlgorithmDukpt
    ] = Optional.Absent,
    dukptIso9797Algorithm1: Optional[
      zio.aws.paymentcryptographydata.model.MacAlgorithmDukpt
    ] = Optional.Absent,
    dukptIso9797Algorithm3: Optional[
      zio.aws.paymentcryptographydata.model.MacAlgorithmDukpt
    ] = Optional.Absent,
    emvMac: Optional[zio.aws.paymentcryptographydata.model.MacAlgorithmEmv] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.MacAttributes = {
    import MacAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.MacAttributes
      .builder()
      .optionallyWith(algorithm.map(value => value.unwrap))(_.algorithm)
      .optionallyWith(dukptCmac.map(value => value.buildAwsValue()))(
        _.dukptCmac
      )
      .optionallyWith(
        dukptIso9797Algorithm1.map(value => value.buildAwsValue())
      )(_.dukptIso9797Algorithm1)
      .optionallyWith(
        dukptIso9797Algorithm3.map(value => value.buildAwsValue())
      )(_.dukptIso9797Algorithm3)
      .optionallyWith(emvMac.map(value => value.buildAwsValue()))(_.emvMac)
      .build()
  }
  def asReadOnly: zio.aws.paymentcryptographydata.model.MacAttributes.ReadOnly =
    zio.aws.paymentcryptographydata.model.MacAttributes.wrap(buildAwsValue())
}
object MacAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.MacAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptographydata.model.MacAttributes =
      zio.aws.paymentcryptographydata.model.MacAttributes(
        algorithm.map(value => value),
        dukptCmac.map(value => value.asEditable),
        dukptIso9797Algorithm1.map(value => value.asEditable),
        dukptIso9797Algorithm3.map(value => value.asEditable),
        emvMac.map(value => value.asEditable)
      )
    def algorithm: Optional[zio.aws.paymentcryptographydata.model.MacAlgorithm]
    def dukptCmac: Optional[
      zio.aws.paymentcryptographydata.model.MacAlgorithmDukpt.ReadOnly
    ]
    def dukptIso9797Algorithm1: Optional[
      zio.aws.paymentcryptographydata.model.MacAlgorithmDukpt.ReadOnly
    ]
    def dukptIso9797Algorithm3: Optional[
      zio.aws.paymentcryptographydata.model.MacAlgorithmDukpt.ReadOnly
    ]
    def emvMac: Optional[
      zio.aws.paymentcryptographydata.model.MacAlgorithmEmv.ReadOnly
    ]
    def getAlgorithm: ZIO[
      Any,
      AwsError,
      zio.aws.paymentcryptographydata.model.MacAlgorithm
    ] = AwsError.unwrapOptionField("algorithm", algorithm)
    def getDukptCmac: ZIO[
      Any,
      AwsError,
      zio.aws.paymentcryptographydata.model.MacAlgorithmDukpt.ReadOnly
    ] = AwsError.unwrapOptionField("dukptCmac", dukptCmac)
    def getDukptIso9797Algorithm1: ZIO[
      Any,
      AwsError,
      zio.aws.paymentcryptographydata.model.MacAlgorithmDukpt.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dukptIso9797Algorithm1",
      dukptIso9797Algorithm1
    )
    def getDukptIso9797Algorithm3: ZIO[
      Any,
      AwsError,
      zio.aws.paymentcryptographydata.model.MacAlgorithmDukpt.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dukptIso9797Algorithm3",
      dukptIso9797Algorithm3
    )
    def getEmvMac: ZIO[
      Any,
      AwsError,
      zio.aws.paymentcryptographydata.model.MacAlgorithmEmv.ReadOnly
    ] = AwsError.unwrapOptionField("emvMac", emvMac)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.MacAttributes
  ) extends zio.aws.paymentcryptographydata.model.MacAttributes.ReadOnly {
    override val algorithm
        : Optional[zio.aws.paymentcryptographydata.model.MacAlgorithm] =
      zio.aws.core.internal
        .optionalFromNullable(impl.algorithm())
        .map(value =>
          zio.aws.paymentcryptographydata.model.MacAlgorithm.wrap(value)
        )
    override val dukptCmac: Optional[
      zio.aws.paymentcryptographydata.model.MacAlgorithmDukpt.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dukptCmac())
      .map(value =>
        zio.aws.paymentcryptographydata.model.MacAlgorithmDukpt.wrap(value)
      )
    override val dukptIso9797Algorithm1: Optional[
      zio.aws.paymentcryptographydata.model.MacAlgorithmDukpt.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dukptIso9797Algorithm1())
      .map(value =>
        zio.aws.paymentcryptographydata.model.MacAlgorithmDukpt.wrap(value)
      )
    override val dukptIso9797Algorithm3: Optional[
      zio.aws.paymentcryptographydata.model.MacAlgorithmDukpt.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dukptIso9797Algorithm3())
      .map(value =>
        zio.aws.paymentcryptographydata.model.MacAlgorithmDukpt.wrap(value)
      )
    override val emvMac: Optional[
      zio.aws.paymentcryptographydata.model.MacAlgorithmEmv.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.emvMac())
      .map(value =>
        zio.aws.paymentcryptographydata.model.MacAlgorithmEmv.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.MacAttributes
  ): zio.aws.paymentcryptographydata.model.MacAttributes.ReadOnly = new Wrapper(
    impl
  )
}
