package zio.aws.paymentcryptographydata.model
import zio.aws.paymentcryptographydata.model.primitives.{
  KeyCheckValue,
  KeyArn,
  HexLengthBetween16And32
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GeneratePinDataResponse(
    encryptedPinBlock: HexLengthBetween16And32,
    encryptionKeyArn: KeyArn,
    encryptionKeyCheckValue: KeyCheckValue,
    generationKeyArn: KeyArn,
    generationKeyCheckValue: KeyCheckValue,
    pinData: zio.aws.paymentcryptographydata.model.PinData
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.GeneratePinDataResponse = {
    import GeneratePinDataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.GeneratePinDataResponse
      .builder()
      .encryptedPinBlock(
        HexLengthBetween16And32.unwrap(encryptedPinBlock): java.lang.String
      )
      .encryptionKeyArn(KeyArn.unwrap(encryptionKeyArn): java.lang.String)
      .encryptionKeyCheckValue(
        KeyCheckValue.unwrap(encryptionKeyCheckValue): java.lang.String
      )
      .generationKeyArn(KeyArn.unwrap(generationKeyArn): java.lang.String)
      .generationKeyCheckValue(
        KeyCheckValue.unwrap(generationKeyCheckValue): java.lang.String
      )
      .pinData(pinData.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptographydata.model.GeneratePinDataResponse.ReadOnly =
    zio.aws.paymentcryptographydata.model.GeneratePinDataResponse
      .wrap(buildAwsValue())
}
object GeneratePinDataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.GeneratePinDataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.paymentcryptographydata.model.GeneratePinDataResponse =
      zio.aws.paymentcryptographydata.model.GeneratePinDataResponse(
        encryptedPinBlock,
        encryptionKeyArn,
        encryptionKeyCheckValue,
        generationKeyArn,
        generationKeyCheckValue,
        pinData.asEditable
      )
    def encryptedPinBlock: HexLengthBetween16And32
    def encryptionKeyArn: KeyArn
    def encryptionKeyCheckValue: KeyCheckValue
    def generationKeyArn: KeyArn
    def generationKeyCheckValue: KeyCheckValue
    def pinData: zio.aws.paymentcryptographydata.model.PinData.ReadOnly
    def getEncryptedPinBlock: ZIO[Any, Nothing, HexLengthBetween16And32] =
      ZIO.succeed(encryptedPinBlock)
    def getEncryptionKeyArn: ZIO[Any, Nothing, KeyArn] =
      ZIO.succeed(encryptionKeyArn)
    def getEncryptionKeyCheckValue: ZIO[Any, Nothing, KeyCheckValue] =
      ZIO.succeed(encryptionKeyCheckValue)
    def getGenerationKeyArn: ZIO[Any, Nothing, KeyArn] =
      ZIO.succeed(generationKeyArn)
    def getGenerationKeyCheckValue: ZIO[Any, Nothing, KeyCheckValue] =
      ZIO.succeed(generationKeyCheckValue)
    def getPinData: ZIO[
      Any,
      Nothing,
      zio.aws.paymentcryptographydata.model.PinData.ReadOnly
    ] = ZIO.succeed(pinData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.GeneratePinDataResponse
  ) extends zio.aws.paymentcryptographydata.model.GeneratePinDataResponse.ReadOnly {
    override val encryptedPinBlock: HexLengthBetween16And32 =
      zio.aws.paymentcryptographydata.model.primitives
        .HexLengthBetween16And32(impl.encryptedPinBlock())
    override val encryptionKeyArn: KeyArn =
      zio.aws.paymentcryptographydata.model.primitives
        .KeyArn(impl.encryptionKeyArn())
    override val encryptionKeyCheckValue: KeyCheckValue =
      zio.aws.paymentcryptographydata.model.primitives
        .KeyCheckValue(impl.encryptionKeyCheckValue())
    override val generationKeyArn: KeyArn =
      zio.aws.paymentcryptographydata.model.primitives
        .KeyArn(impl.generationKeyArn())
    override val generationKeyCheckValue: KeyCheckValue =
      zio.aws.paymentcryptographydata.model.primitives
        .KeyCheckValue(impl.generationKeyCheckValue())
    override val pinData
        : zio.aws.paymentcryptographydata.model.PinData.ReadOnly =
      zio.aws.paymentcryptographydata.model.PinData.wrap(impl.pinData())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.GeneratePinDataResponse
  ): zio.aws.paymentcryptographydata.model.GeneratePinDataResponse.ReadOnly =
    new Wrapper(impl)
}
