package zio.aws.paymentcryptographydata.model
import zio.aws.paymentcryptographydata.model.primitives.{
  HexLengthBetween4And128,
  KeyCheckValue,
  KeyArn
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GenerateMacResponse(
    keyArn: KeyArn,
    keyCheckValue: KeyCheckValue,
    mac: HexLengthBetween4And128
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.GenerateMacResponse = {
    import GenerateMacResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.GenerateMacResponse
      .builder()
      .keyArn(KeyArn.unwrap(keyArn): java.lang.String)
      .keyCheckValue(KeyCheckValue.unwrap(keyCheckValue): java.lang.String)
      .mac(HexLengthBetween4And128.unwrap(mac): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptographydata.model.GenerateMacResponse.ReadOnly =
    zio.aws.paymentcryptographydata.model.GenerateMacResponse
      .wrap(buildAwsValue())
}
object GenerateMacResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.GenerateMacResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptographydata.model.GenerateMacResponse =
      zio.aws.paymentcryptographydata.model
        .GenerateMacResponse(keyArn, keyCheckValue, mac)
    def keyArn: KeyArn
    def keyCheckValue: KeyCheckValue
    def mac: HexLengthBetween4And128
    def getKeyArn: ZIO[Any, Nothing, KeyArn] = ZIO.succeed(keyArn)
    def getKeyCheckValue: ZIO[Any, Nothing, KeyCheckValue] =
      ZIO.succeed(keyCheckValue)
    def getMac: ZIO[Any, Nothing, HexLengthBetween4And128] = ZIO.succeed(mac)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.GenerateMacResponse
  ) extends zio.aws.paymentcryptographydata.model.GenerateMacResponse.ReadOnly {
    override val keyArn: KeyArn =
      zio.aws.paymentcryptographydata.model.primitives.KeyArn(impl.keyArn())
    override val keyCheckValue: KeyCheckValue =
      zio.aws.paymentcryptographydata.model.primitives
        .KeyCheckValue(impl.keyCheckValue())
    override val mac: HexLengthBetween4And128 =
      zio.aws.paymentcryptographydata.model.primitives
        .HexLengthBetween4And128(impl.mac())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.GenerateMacResponse
  ): zio.aws.paymentcryptographydata.model.GenerateMacResponse.ReadOnly =
    new Wrapper(impl)
}
