package zio.aws.paymentcryptographydata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EncryptionDecryptionAttributes(
    asymmetric: Optional[
      zio.aws.paymentcryptographydata.model.AsymmetricEncryptionAttributes
    ] = Optional.Absent,
    dukpt: Optional[
      zio.aws.paymentcryptographydata.model.DukptEncryptionAttributes
    ] = Optional.Absent,
    symmetric: Optional[
      zio.aws.paymentcryptographydata.model.SymmetricEncryptionAttributes
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.EncryptionDecryptionAttributes = {
    import EncryptionDecryptionAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.EncryptionDecryptionAttributes
      .builder()
      .optionallyWith(asymmetric.map(value => value.buildAwsValue()))(
        _.asymmetric
      )
      .optionallyWith(dukpt.map(value => value.buildAwsValue()))(_.dukpt)
      .optionallyWith(symmetric.map(value => value.buildAwsValue()))(
        _.symmetric
      )
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptographydata.model.EncryptionDecryptionAttributes.ReadOnly =
    zio.aws.paymentcryptographydata.model.EncryptionDecryptionAttributes
      .wrap(buildAwsValue())
}
object EncryptionDecryptionAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.EncryptionDecryptionAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.paymentcryptographydata.model.EncryptionDecryptionAttributes =
      zio.aws.paymentcryptographydata.model.EncryptionDecryptionAttributes(
        asymmetric.map(value => value.asEditable),
        dukpt.map(value => value.asEditable),
        symmetric.map(value => value.asEditable)
      )
    def asymmetric: Optional[
      zio.aws.paymentcryptographydata.model.AsymmetricEncryptionAttributes.ReadOnly
    ]
    def dukpt: Optional[
      zio.aws.paymentcryptographydata.model.DukptEncryptionAttributes.ReadOnly
    ]
    def symmetric: Optional[
      zio.aws.paymentcryptographydata.model.SymmetricEncryptionAttributes.ReadOnly
    ]
    def getAsymmetric: ZIO[
      Any,
      AwsError,
      zio.aws.paymentcryptographydata.model.AsymmetricEncryptionAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("asymmetric", asymmetric)
    def getDukpt: ZIO[
      Any,
      AwsError,
      zio.aws.paymentcryptographydata.model.DukptEncryptionAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("dukpt", dukpt)
    def getSymmetric: ZIO[
      Any,
      AwsError,
      zio.aws.paymentcryptographydata.model.SymmetricEncryptionAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("symmetric", symmetric)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.EncryptionDecryptionAttributes
  ) extends zio.aws.paymentcryptographydata.model.EncryptionDecryptionAttributes.ReadOnly {
    override val asymmetric: Optional[
      zio.aws.paymentcryptographydata.model.AsymmetricEncryptionAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.asymmetric())
      .map(value =>
        zio.aws.paymentcryptographydata.model.AsymmetricEncryptionAttributes
          .wrap(value)
      )
    override val dukpt: Optional[
      zio.aws.paymentcryptographydata.model.DukptEncryptionAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dukpt())
      .map(value =>
        zio.aws.paymentcryptographydata.model.DukptEncryptionAttributes
          .wrap(value)
      )
    override val symmetric: Optional[
      zio.aws.paymentcryptographydata.model.SymmetricEncryptionAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.symmetric())
      .map(value =>
        zio.aws.paymentcryptographydata.model.SymmetricEncryptionAttributes
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.EncryptionDecryptionAttributes
  ): zio.aws.paymentcryptographydata.model.EncryptionDecryptionAttributes.ReadOnly =
    new Wrapper(impl)
}
