package zio.aws.paymentcryptographydata.model
import zio.aws.paymentcryptographydata.model.primitives.{
  HexLengthBetween2And8,
  HexLengthBetween2And160,
  HexLengthEquals2,
  HexLengthBetween2And4
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DynamicCardVerificationCode(
    applicationTransactionCounter: HexLengthBetween2And4,
    panSequenceNumber: HexLengthEquals2,
    trackData: HexLengthBetween2And160,
    unpredictableNumber: HexLengthBetween2And8
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.DynamicCardVerificationCode = {
    import DynamicCardVerificationCode.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.DynamicCardVerificationCode
      .builder()
      .applicationTransactionCounter(
        HexLengthBetween2And4.unwrap(
          applicationTransactionCounter
        ): java.lang.String
      )
      .panSequenceNumber(
        HexLengthEquals2.unwrap(panSequenceNumber): java.lang.String
      )
      .trackData(HexLengthBetween2And160.unwrap(trackData): java.lang.String)
      .unpredictableNumber(
        HexLengthBetween2And8.unwrap(unpredictableNumber): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptographydata.model.DynamicCardVerificationCode.ReadOnly =
    zio.aws.paymentcryptographydata.model.DynamicCardVerificationCode
      .wrap(buildAwsValue())
}
object DynamicCardVerificationCode {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.DynamicCardVerificationCode
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.paymentcryptographydata.model.DynamicCardVerificationCode =
      zio.aws.paymentcryptographydata.model.DynamicCardVerificationCode(
        applicationTransactionCounter,
        panSequenceNumber,
        trackData,
        unpredictableNumber
      )
    def applicationTransactionCounter: HexLengthBetween2And4
    def panSequenceNumber: HexLengthEquals2
    def trackData: HexLengthBetween2And160
    def unpredictableNumber: HexLengthBetween2And8
    def getApplicationTransactionCounter
        : ZIO[Any, Nothing, HexLengthBetween2And4] =
      ZIO.succeed(applicationTransactionCounter)
    def getPanSequenceNumber: ZIO[Any, Nothing, HexLengthEquals2] =
      ZIO.succeed(panSequenceNumber)
    def getTrackData: ZIO[Any, Nothing, HexLengthBetween2And160] =
      ZIO.succeed(trackData)
    def getUnpredictableNumber: ZIO[Any, Nothing, HexLengthBetween2And8] =
      ZIO.succeed(unpredictableNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.DynamicCardVerificationCode
  ) extends zio.aws.paymentcryptographydata.model.DynamicCardVerificationCode.ReadOnly {
    override val applicationTransactionCounter: HexLengthBetween2And4 =
      zio.aws.paymentcryptographydata.model.primitives
        .HexLengthBetween2And4(impl.applicationTransactionCounter())
    override val panSequenceNumber: HexLengthEquals2 =
      zio.aws.paymentcryptographydata.model.primitives
        .HexLengthEquals2(impl.panSequenceNumber())
    override val trackData: HexLengthBetween2And160 =
      zio.aws.paymentcryptographydata.model.primitives
        .HexLengthBetween2And160(impl.trackData())
    override val unpredictableNumber: HexLengthBetween2And8 =
      zio.aws.paymentcryptographydata.model.primitives
        .HexLengthBetween2And8(impl.unpredictableNumber())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.DynamicCardVerificationCode
  ): zio.aws.paymentcryptographydata.model.DynamicCardVerificationCode.ReadOnly =
    new Wrapper(impl)
}
