package zio.aws.paymentcryptographydata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CardVerificationAttributes(
    amexCardSecurityCodeVersion1: Optional[
      zio.aws.paymentcryptographydata.model.AmexCardSecurityCodeVersion1
    ] = Optional.Absent,
    amexCardSecurityCodeVersion2: Optional[
      zio.aws.paymentcryptographydata.model.AmexCardSecurityCodeVersion2
    ] = Optional.Absent,
    cardHolderVerificationValue: Optional[
      zio.aws.paymentcryptographydata.model.CardHolderVerificationValue
    ] = Optional.Absent,
    cardVerificationValue1: Optional[
      zio.aws.paymentcryptographydata.model.CardVerificationValue1
    ] = Optional.Absent,
    cardVerificationValue2: Optional[
      zio.aws.paymentcryptographydata.model.CardVerificationValue2
    ] = Optional.Absent,
    discoverDynamicCardVerificationCode: Optional[
      zio.aws.paymentcryptographydata.model.DiscoverDynamicCardVerificationCode
    ] = Optional.Absent,
    dynamicCardVerificationCode: Optional[
      zio.aws.paymentcryptographydata.model.DynamicCardVerificationCode
    ] = Optional.Absent,
    dynamicCardVerificationValue: Optional[
      zio.aws.paymentcryptographydata.model.DynamicCardVerificationValue
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.CardVerificationAttributes = {
    import CardVerificationAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.CardVerificationAttributes
      .builder()
      .optionallyWith(
        amexCardSecurityCodeVersion1.map(value => value.buildAwsValue())
      )(_.amexCardSecurityCodeVersion1)
      .optionallyWith(
        amexCardSecurityCodeVersion2.map(value => value.buildAwsValue())
      )(_.amexCardSecurityCodeVersion2)
      .optionallyWith(
        cardHolderVerificationValue.map(value => value.buildAwsValue())
      )(_.cardHolderVerificationValue)
      .optionallyWith(
        cardVerificationValue1.map(value => value.buildAwsValue())
      )(_.cardVerificationValue1)
      .optionallyWith(
        cardVerificationValue2.map(value => value.buildAwsValue())
      )(_.cardVerificationValue2)
      .optionallyWith(
        discoverDynamicCardVerificationCode.map(value => value.buildAwsValue())
      )(_.discoverDynamicCardVerificationCode)
      .optionallyWith(
        dynamicCardVerificationCode.map(value => value.buildAwsValue())
      )(_.dynamicCardVerificationCode)
      .optionallyWith(
        dynamicCardVerificationValue.map(value => value.buildAwsValue())
      )(_.dynamicCardVerificationValue)
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptographydata.model.CardVerificationAttributes.ReadOnly =
    zio.aws.paymentcryptographydata.model.CardVerificationAttributes
      .wrap(buildAwsValue())
}
object CardVerificationAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.CardVerificationAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.paymentcryptographydata.model.CardVerificationAttributes =
      zio.aws.paymentcryptographydata.model.CardVerificationAttributes(
        amexCardSecurityCodeVersion1.map(value => value.asEditable),
        amexCardSecurityCodeVersion2.map(value => value.asEditable),
        cardHolderVerificationValue.map(value => value.asEditable),
        cardVerificationValue1.map(value => value.asEditable),
        cardVerificationValue2.map(value => value.asEditable),
        discoverDynamicCardVerificationCode.map(value => value.asEditable),
        dynamicCardVerificationCode.map(value => value.asEditable),
        dynamicCardVerificationValue.map(value => value.asEditable)
      )
    def amexCardSecurityCodeVersion1: Optional[
      zio.aws.paymentcryptographydata.model.AmexCardSecurityCodeVersion1.ReadOnly
    ]
    def amexCardSecurityCodeVersion2: Optional[
      zio.aws.paymentcryptographydata.model.AmexCardSecurityCodeVersion2.ReadOnly
    ]
    def cardHolderVerificationValue: Optional[
      zio.aws.paymentcryptographydata.model.CardHolderVerificationValue.ReadOnly
    ]
    def cardVerificationValue1: Optional[
      zio.aws.paymentcryptographydata.model.CardVerificationValue1.ReadOnly
    ]
    def cardVerificationValue2: Optional[
      zio.aws.paymentcryptographydata.model.CardVerificationValue2.ReadOnly
    ]
    def discoverDynamicCardVerificationCode: Optional[
      zio.aws.paymentcryptographydata.model.DiscoverDynamicCardVerificationCode.ReadOnly
    ]
    def dynamicCardVerificationCode: Optional[
      zio.aws.paymentcryptographydata.model.DynamicCardVerificationCode.ReadOnly
    ]
    def dynamicCardVerificationValue: Optional[
      zio.aws.paymentcryptographydata.model.DynamicCardVerificationValue.ReadOnly
    ]
    def getAmexCardSecurityCodeVersion1: ZIO[
      Any,
      AwsError,
      zio.aws.paymentcryptographydata.model.AmexCardSecurityCodeVersion1.ReadOnly
    ] = AwsError.unwrapOptionField(
      "amexCardSecurityCodeVersion1",
      amexCardSecurityCodeVersion1
    )
    def getAmexCardSecurityCodeVersion2: ZIO[
      Any,
      AwsError,
      zio.aws.paymentcryptographydata.model.AmexCardSecurityCodeVersion2.ReadOnly
    ] = AwsError.unwrapOptionField(
      "amexCardSecurityCodeVersion2",
      amexCardSecurityCodeVersion2
    )
    def getCardHolderVerificationValue: ZIO[
      Any,
      AwsError,
      zio.aws.paymentcryptographydata.model.CardHolderVerificationValue.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cardHolderVerificationValue",
      cardHolderVerificationValue
    )
    def getCardVerificationValue1: ZIO[
      Any,
      AwsError,
      zio.aws.paymentcryptographydata.model.CardVerificationValue1.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cardVerificationValue1",
      cardVerificationValue1
    )
    def getCardVerificationValue2: ZIO[
      Any,
      AwsError,
      zio.aws.paymentcryptographydata.model.CardVerificationValue2.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cardVerificationValue2",
      cardVerificationValue2
    )
    def getDiscoverDynamicCardVerificationCode: ZIO[
      Any,
      AwsError,
      zio.aws.paymentcryptographydata.model.DiscoverDynamicCardVerificationCode.ReadOnly
    ] = AwsError.unwrapOptionField(
      "discoverDynamicCardVerificationCode",
      discoverDynamicCardVerificationCode
    )
    def getDynamicCardVerificationCode: ZIO[
      Any,
      AwsError,
      zio.aws.paymentcryptographydata.model.DynamicCardVerificationCode.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dynamicCardVerificationCode",
      dynamicCardVerificationCode
    )
    def getDynamicCardVerificationValue: ZIO[
      Any,
      AwsError,
      zio.aws.paymentcryptographydata.model.DynamicCardVerificationValue.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dynamicCardVerificationValue",
      dynamicCardVerificationValue
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.CardVerificationAttributes
  ) extends zio.aws.paymentcryptographydata.model.CardVerificationAttributes.ReadOnly {
    override val amexCardSecurityCodeVersion1: Optional[
      zio.aws.paymentcryptographydata.model.AmexCardSecurityCodeVersion1.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.amexCardSecurityCodeVersion1())
      .map(value =>
        zio.aws.paymentcryptographydata.model.AmexCardSecurityCodeVersion1
          .wrap(value)
      )
    override val amexCardSecurityCodeVersion2: Optional[
      zio.aws.paymentcryptographydata.model.AmexCardSecurityCodeVersion2.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.amexCardSecurityCodeVersion2())
      .map(value =>
        zio.aws.paymentcryptographydata.model.AmexCardSecurityCodeVersion2
          .wrap(value)
      )
    override val cardHolderVerificationValue: Optional[
      zio.aws.paymentcryptographydata.model.CardHolderVerificationValue.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.cardHolderVerificationValue())
      .map(value =>
        zio.aws.paymentcryptographydata.model.CardHolderVerificationValue
          .wrap(value)
      )
    override val cardVerificationValue1: Optional[
      zio.aws.paymentcryptographydata.model.CardVerificationValue1.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.cardVerificationValue1())
      .map(value =>
        zio.aws.paymentcryptographydata.model.CardVerificationValue1.wrap(value)
      )
    override val cardVerificationValue2: Optional[
      zio.aws.paymentcryptographydata.model.CardVerificationValue2.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.cardVerificationValue2())
      .map(value =>
        zio.aws.paymentcryptographydata.model.CardVerificationValue2.wrap(value)
      )
    override val discoverDynamicCardVerificationCode: Optional[
      zio.aws.paymentcryptographydata.model.DiscoverDynamicCardVerificationCode.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.discoverDynamicCardVerificationCode())
      .map(value =>
        zio.aws.paymentcryptographydata.model.DiscoverDynamicCardVerificationCode
          .wrap(value)
      )
    override val dynamicCardVerificationCode: Optional[
      zio.aws.paymentcryptographydata.model.DynamicCardVerificationCode.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dynamicCardVerificationCode())
      .map(value =>
        zio.aws.paymentcryptographydata.model.DynamicCardVerificationCode
          .wrap(value)
      )
    override val dynamicCardVerificationValue: Optional[
      zio.aws.paymentcryptographydata.model.DynamicCardVerificationValue.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dynamicCardVerificationValue())
      .map(value =>
        zio.aws.paymentcryptographydata.model.DynamicCardVerificationValue
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.CardVerificationAttributes
  ): zio.aws.paymentcryptographydata.model.CardVerificationAttributes.ReadOnly =
    new Wrapper(impl)
}
