package zio.aws.paymentcryptographydata.model
import zio.aws.paymentcryptographydata.model.primitives.{
  NumberLengthEquals3,
  NumberLengthEquals4
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AmexCardSecurityCodeVersion2(
    cardExpiryDate: NumberLengthEquals4,
    serviceCode: NumberLengthEquals3
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.AmexCardSecurityCodeVersion2 = {
    import AmexCardSecurityCodeVersion2.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.AmexCardSecurityCodeVersion2
      .builder()
      .cardExpiryDate(
        NumberLengthEquals4.unwrap(cardExpiryDate): java.lang.String
      )
      .serviceCode(NumberLengthEquals3.unwrap(serviceCode): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptographydata.model.AmexCardSecurityCodeVersion2.ReadOnly =
    zio.aws.paymentcryptographydata.model.AmexCardSecurityCodeVersion2
      .wrap(buildAwsValue())
}
object AmexCardSecurityCodeVersion2 {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.AmexCardSecurityCodeVersion2
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.paymentcryptographydata.model.AmexCardSecurityCodeVersion2 =
      zio.aws.paymentcryptographydata.model
        .AmexCardSecurityCodeVersion2(cardExpiryDate, serviceCode)
    def cardExpiryDate: NumberLengthEquals4
    def serviceCode: NumberLengthEquals3
    def getCardExpiryDate: ZIO[Any, Nothing, NumberLengthEquals4] =
      ZIO.succeed(cardExpiryDate)
    def getServiceCode: ZIO[Any, Nothing, NumberLengthEquals3] =
      ZIO.succeed(serviceCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.AmexCardSecurityCodeVersion2
  ) extends zio.aws.paymentcryptographydata.model.AmexCardSecurityCodeVersion2.ReadOnly {
    override val cardExpiryDate: NumberLengthEquals4 =
      zio.aws.paymentcryptographydata.model.primitives
        .NumberLengthEquals4(impl.cardExpiryDate())
    override val serviceCode: NumberLengthEquals3 =
      zio.aws.paymentcryptographydata.model.primitives
        .NumberLengthEquals3(impl.serviceCode())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.AmexCardSecurityCodeVersion2
  ): zio.aws.paymentcryptographydata.model.AmexCardSecurityCodeVersion2.ReadOnly =
    new Wrapper(impl)
}
